function tsedit()
% Creates and edits a Thomas-Stieber plot of porosity vs. vshale.  
%
% The porosity of clean sand and shale end members (Phi_sand and Phi_shale)
% can be edited by clicking desired new positions on plot. 
% Hit RETURN to stop editing.
%

% written by Gary Mavko


% First, look to see if current figure is suitable.  If no figure exists,
% then this will create a blank figure.

% Find all figures
hfigs = findobj(0,'type','figure');

% If no figure with axes exists, create one and plot default TS graph.
if isempty(findobj(0,'type','axes')),
    figure; 
    phisand = 0.4;
    phishale = 0.2;
    phimin = phisand*phishale;
    vshcrit = phisand;
    hgcf = figure(gcf);
    hgca = gca;
    xlim = [0 1];tsedit

    x = [0 1 vshcrit 0];
    y = [phisand phishale phimin phisand];
    x1 = [0.2*(vshcrit-0) 1];
    x2 = [0.4*(vshcrit-0) 1];
    x3 = [0.6*(vshcrit-0) 1];
    x4 = [0.8*(vshcrit-0) 1];
    x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
    y1 = [phisand+0.2*(phimin-phisand) phishale];
    y2 = [phisand+0.4*(phimin-phisand) phishale];
    y3 = [phisand+0.6*(phimin-phisand) phishale];
    y4 = [phisand+0.8*(phimin-phisand) phishale];
    y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
    hold on;
    htslines = plot(x,y,'-k','linewidth',2);
    htslines1 = plot(x1,y1,'-k','linewidth',1);
    htslines2 = plot(x2,y2,'-k','linewidth',1);
    htslines3 = plot(x3,y3,'-k','linewidth',1);
    htslines4 = plot(x4,y4,'-k','linewidth',1);
    htslines5 = plot(x5,y5,'-k','linewidth',1);
    set(htslines,'tag','tslines');
    set(htslines1,'tag','tslines1');
    set(htslines2,'tag','tslines2');
    set(htslines3,'tag','tslines3');
    set(htslines4,'tag','tslines4');
    set(htslines5,'tag','tslines5');
    set(gcf,'userdata',{'vsh' 'phi'});
    xlabel('vsh'); ylabel('phi'); 
    
% If some TS plots exist, ask user whether to edit or make new
elseif ~isempty(findobj(hfigs,'tag','tslines')), 
    choice = menu('What do you wish to do?', ...
        'Create new TS plot?',...
        'Edit an existing TS plot?',...
        'Superimpose on existing data plot');
    if choice ==1,    % Create new plot
        figure; 
        phisand = 0.4;
        phishale = 0.2;
        phimin = phisand*phishale;
        vshcrit = phisand;
        hgcf = figure(gcf);
        hgca = gca;
        xlim = [0 1];

        x = [0 1 vshcrit 0];
        y = [phisand phishale phimin phisand];
        x1 = [0.2*(vshcrit-0) 1];
        x2 = [0.4*(vshcrit-0) 1];
        x3 = [0.6*(vshcrit-0) 1];
        x4 = [0.8*(vshcrit-0) 1];
        x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
        y1 = [phisand+0.2*(phimin-phisand) phishale];
        y2 = [phisand+0.4*(phimin-phisand) phishale];
        y3 = [phisand+0.6*(phimin-phisand) phishale];
        y4 = [phisand+0.8*(phimin-phisand) phishale];
        y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
        hold on;
        htslines = plot(x,y,'-k','linewidth',2);
        htslines1 = plot(x1,y1,'-k','linewidth',1);
        htslines2 = plot(x2,y2,'-k','linewidth',1);
        htslines3 = plot(x3,y3,'-k','linewidth',1);
        htslines4 = plot(x4,y4,'-k','linewidth',1);
        htslines5 = plot(x5,y5,'-k','linewidth',1);
        set(htslines,'tag','tslines');
        set(htslines1,'tag','tslines1');
        set(htslines2,'tag','tslines2');
        set(htslines3,'tag','tslines3');
        set(htslines4,'tag','tslines4');
        set(htslines5,'tag','tslines5');
        set(gcf,'userdata',{'vsh' 'phi'});
        xlabel('vsh'); ylabel('phi'); 
    elseif choice ==2,    % Edit existing TS plot
        okselect = 0;
        while okselect==0,
            hmsg = msgbox('Select Existing TS Figure to Edit');
            waitforbuttonpress;
 %           waitforbuttonpress;
            if ishandle(hmsg), delete(hmsg); end;
            if ~isempty(findobj(gcf,'tag','tslines')), okselect=1; end;
        end;        
      % get the existing sand and shale values.
        htslines = findobj(gcf,'tag','tslines');
        xdata = get(htslines,'xdata');
        ydata = get(htslines,'ydata');
        xmin = min(xdata);
        ixmin = min(find(xdata==xmin));
        phisand = ydata(ixmin);
        xmax = max(xdata);
        ixmax = min(find(xdata==xmax));
        phishale = ydata(ixmax);
    elseif choice ==3,    % Superimpose on existing data plot
        okselect = 0;
        while okselect==0,
            hmsg = msgbox('Select Vsh-Phi plot to Superimpose');
            waitforbuttonpress;
%            waitforbuttonpress;
            if ishandle(hmsg), delete(hmsg); end;
            if ~isempty(findobj(gcf,'type','line')), okselect=1; end;
        end;
        if ~isempty(findobj(gcf,'tag','tslines')), return; end;
        hold on; 
        phisand = 0.4;
        phishale = 0.2;
        phimin = phisand*phishale;
        vshcrit = phisand;
        hgcf = figure(gcf);
        hgca = gca;
        xlim = [0 1];

        x = [0 1 vshcrit 0];
        y = [phisand phishale phimin phisand];
        x1 = [0.2*(vshcrit-0) 1];
        x2 = [0.4*(vshcrit-0) 1];
        x3 = [0.6*(vshcrit-0) 1];
        x4 = [0.8*(vshcrit-0) 1];
        x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
        y1 = [phisand+0.2*(phimin-phisand) phishale];
        y2 = [phisand+0.4*(phimin-phisand) phishale];
        y3 = [phisand+0.6*(phimin-phisand) phishale];
        y4 = [phisand+0.8*(phimin-phisand) phishale];
        y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
        hold on;
        htslines = plot(x,y,'-k','linewidth',2);
        htslines1 = plot(x1,y1,'-k','linewidth',1);
        htslines2 = plot(x2,y2,'-k','linewidth',1);
        htslines3 = plot(x3,y3,'-k','linewidth',1);
        htslines4 = plot(x4,y4,'-k','linewidth',1);
        htslines5 = plot(x5,y5,'-k','linewidth',1);
        set(htslines,'tag','tslines');
        set(htslines1,'tag','tslines1');
        set(htslines2,'tag','tslines2');
        set(htslines3,'tag','tslines3');
        set(htslines4,'tag','tslines4');
        set(htslines5,'tag','tslines5');
    end;
    
% Plots exist, but not existing TS plots
else     
    choice = menu('What do you wish to do?', ...
        'Create new TS plot?',...
        'Superimpose on existing data plot');
    if choice ==1,    % Create new plot
        figure; 
        phisand = 0.4;
        phishale = 0.2;
        phimin = phisand*phishale;
        vshcrit = phisand;
        hgcf = figure(gcf);
        hgca = gca;
        xlim = [0 1];

        x = [0 1 vshcrit 0];
        y = [phisand phishale phimin phisand];
        x1 = [0.2*(vshcrit-0) 1];
        x2 = [0.4*(vshcrit-0) 1];
        x3 = [0.6*(vshcrit-0) 1];
        x4 = [0.8*(vshcrit-0) 1];
        x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
        y1 = [phisand+0.2*(phimin-phisand) phishale];
        y2 = [phisand+0.4*(phimin-phisand) phishale];
        y3 = [phisand+0.6*(phimin-phisand) phishale];
        y4 = [phisand+0.8*(phimin-phisand) phishale];
        y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
        hold on;
        htslines = plot(x,y,'-k','linewidth',2);
        htslines1 = plot(x1,y1,'-k','linewidth',1);
        htslines2 = plot(x2,y2,'-k','linewidth',1);
        htslines3 = plot(x3,y3,'-k','linewidth',1);
        htslines4 = plot(x4,y4,'-k','linewidth',1);
        htslines5 = plot(x5,y5,'-k','linewidth',1);
        set(htslines,'tag','tslines');
        set(htslines1,'tag','tslines1');
        set(htslines2,'tag','tslines2');
        set(htslines3,'tag','tslines3');
        set(htslines4,'tag','tslines4');
        set(htslines5,'tag','tslines5');
        set(gcf,'userdata',{'vsh' 'phi'});
        xlabel('vsh'); ylabel('phi'); 
    elseif choice ==2,    % Superimpose on existing data plot
        okselect = 0;
        while okselect==0,
            hmsg = msgbox('Select Vsh-Phi plot to Superimpose');
            waitforbuttonpress;
%            waitforbuttonpress;
            if ishandle(hmsg), delete(hmsg); end;
            if ~isempty(findobj(gcf,'type','line')), okselect=1; end;
        end;
        if ~isempty(findobj(gcf,'tag','tslines')), return; end;
        hold on; 
        phisand = 0.4;
        phishale = 0.2;
        phimin = phisand*phishale;
        vshcrit = phisand;
        hgcf = figure(gcf);
        hgca = gca;
        xlim = [0 1];

        x = [0 1 vshcrit 0];
        y = [phisand phishale phimin phisand];
        x1 = [0.2*(vshcrit-0) 1];
        x2 = [0.4*(vshcrit-0) 1];
        x3 = [0.6*(vshcrit-0) 1];
        x4 = [0.8*(vshcrit-0) 1];
        x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
        y1 = [phisand+0.2*(phimin-phisand) phishale];
        y2 = [phisand+0.4*(phimin-phisand) phishale];
        y3 = [phisand+0.6*(phimin-phisand) phishale];
        y4 = [phisand+0.8*(phimin-phisand) phishale];
        y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
        hold on;
        htslines = plot(x,y,'-k','linewidth',2);
        htslines1 = plot(x1,y1,'-k','linewidth',1);
        htslines2 = plot(x2,y2,'-k','linewidth',1);
        htslines3 = plot(x3,y3,'-k','linewidth',1);
        htslines4 = plot(x4,y4,'-k','linewidth',1);
        htslines5 = plot(x5,y5,'-k','linewidth',1);
        set(htslines,'tag','tslines');
        set(htslines1,'tag','tslines1');
        set(htslines2,'tag','tslines2');
        set(htslines3,'tag','tslines3');
        set(htslines4,'tag','tslines4');
        set(htslines5,'tag','tslines5');
    end;
end;
    

[xclick yclick]=ginput(1);

while ~isempty(xclick)
    htslines=findobj(gca,'tag','tslines');
    htslines1=findobj(gca,'tag','tslines1');
    htslines2=findobj(gca,'tag','tslines2');
    htslines3=findobj(gca,'tag','tslines3');
    htslines4=findobj(gca,'tag','tslines4');
    htslines5=findobj(gca,'tag','tslines5');
    
    if abs(xclick)<.5,
        phisand = yclick;
    elseif abs(1-xclick)< .5,
        phishale = yclick;
    end;
    phimin = phisand*phishale;
    vshcrit = phisand;
        x = [0 1 vshcrit 0];
        y = [phisand phishale phimin phisand];
        x1 = [0.2*(vshcrit-0) 1];
        x2 = [0.4*(vshcrit-0) 1];
        x3 = [0.6*(vshcrit-0) 1];
        x4 = [0.8*(vshcrit-0) 1];
        x5 = [0.5 vshcrit+0.5*(1-vshcrit)];
        y1 = [phisand+0.2*(phimin-phisand) phishale];
        y2 = [phisand+0.4*(phimin-phisand) phishale];
        y3 = [phisand+0.6*(phimin-phisand) phishale];
        y4 = [phisand+0.8*(phimin-phisand) phishale];
        y5 = [phisand + 0.5*(phishale-phisand) phimin+0.5*(phishale-phimin)];
    set(htslines,'xdata',x);
    set(htslines1,'xdata',x1);
    set(htslines2,'xdata',x2);
    set(htslines3,'xdata',x3);
    set(htslines4,'xdata',x4);
    set(htslines5,'xdata',x5);
    set(htslines,'ydata',y);
    set(htslines1,'ydata',y1);
    set(htslines2,'ydata',y2);
    set(htslines3,'ydata',y3);
    set(htslines4,'ydata',y4);
    set(htslines5,'ydata',y5);
    [xclick yclick]=ginput(1);
end;
