function slice3u(varargin)
%SLICE3U(X,Y,Z,V) a graphic tool for slicing and visualizing 3d data cubes.
%SLICE3U(V) assumes X=1:NX, Y=1:NY, Z=1:NZ where [NX, NY, NZ}=size(V).
%X,Y,Z are vectors defining the axes. X corresponds to columns and Y to the
%rows of each Z-slice of V. Z-axis increases upwards. Color axis limits
%may be specified (optional) as SLICE3U(X,Y,Z,V,[CMIN, CMAX]) or
%SLICE3U(V,[CMIN, CMAX]).
%
%See also SLICE, SLICE3D

%Written by T. Mukerji

nin=nargin;
if nin==1, v=varargin{1}; clrlmt=[]; varargin=[]; 
if ndims(v)~=3, error('V must be a 3-D array.'); end
[ny,nx,nz] = size(v); x=1:nx; y=1:ny; z=1:nz;
end;
if nin==2, v=varargin{1}; clrlmt=varargin{2}; varargin=[]; 
if ndims(v)~=3, error('V must be a 3-D array.'); end
[ny,nx,nz] = size(v); x=1:nx; y=1:ny; z=1:nz;
end;

if nin==4, x=varargin{1}; y=varargin{2}; z=varargin{3}; v=varargin{4};
clrlmt=[]; varargin=[]; end;
if nin==5, x=varargin{1}; y=varargin{2}; z=varargin{3}; v=varargin{4};
clrlmt=varargin{5}; varargin=[]; end;

if ndims(v)~=3, error('V must be a 3-D array.'); end
[ny,nx,nz] = size(v);

figure;
hax3d=subplot('position',[0.25 0.55 0.50 0.4]);
slice(x,y,z,v,[min(x) max(x)],[min(y) max(y)],[min(z) max(z)]),shading flat; 
rotate3d on;
if ~isempty(clrlmt), set(hax3d,'clim',clrlmt); end; colorbar;
if isempty(clrlmt), clrlmt=get(hax3d,'clim'); end;
set(hax3d,'zdir','normal'); axis tight;
xlabel('X'); ylabel('Y'); zlabel('Z'); 
set(hax3d,'tag','ax3d','userdata',{x,y,z,v});
xlxpts=[min(x) min(x) min(x) min(x) min(x)];
xlypts=[min(y) min(y) max(y) max(y) min(y)];
xlzpts=[min(z) max(z) max(z) min(z) max(z)];
hxl=line(xlxpts(1:3),xlypts(1:3),xlzpts(1:3));
set(hxl,'color',[0.5 0.5 0.5],'erasemode','xor','linewidth',2,'tag','sxline');
ylxpts=[min(x) min(x) max(x) max(x) min(x)];
ylypts=[min(y) min(y) min(y) min(y) min(y)];
ylzpts=[min(z) max(z) max(z) min(z) min(z)];
hyl=line(ylxpts(1:3),ylypts(1:3),ylzpts(1:3));
set(hyl,'color',[0.5 0.5 0.5],'erasemode','xor','linewidth',2,'tag','syline');
zlxpts=[min(x) min(x) max(x) max(x) min(x)];
zlypts=[max(y) min(y) min(y) max(y) max(y)];
zlzpts=[min(z) min(z) min(z) min(z) min(z)]; 
hzl=line(zlxpts(1:3),zlypts(1:3),zlzpts(1:3));
set(hzl,'color',[0.5 0.5 0.5],'erasemode','xor','linewidth',2,'tag','szline');
drawnow;

hx=subplot('position',[0.05 0.25 0.25 0.2]);
imagesc(y,z,squeeze(v(:,1,:)).'); axis xy; set(hx,'xdir','reverse');
set(hx,'clim',clrlmt);
hximg=get(hx,'children'); set(hximg,'erasemode','none','tag','ximg');
title('Constant X slice'); drawnow;

hz=subplot('position',[0.35 0.25 0.25 0.2]);
imagesc(x,y,v(:,:,1)),axis xy;
set(hz,'clim',clrlmt);
hzimg=get(hz,'children'); set(hzimg,'erasemode','none','tag','zimg'); 
title('Constant Z slice'); drawnow;

hy=subplot('position',[0.65 0.25 0.25 0.2]);
imagesc(x,z,squeeze(v(1,:,:)).'); axis xy;
set(hy,'clim',clrlmt);
hyimg=get(hy,'children'); set(hyimg,'erasemode','none','tag','yimg');
title('Constant Y slice'); drawnow;

hxslider=uicontrol('style', 'slider',...
                   'units', 'normalized',...
                   'position',[0.07 0.1 0.17 0.035],...
                   'min',min(x),...
                   'max',max(x),...
                   'value',min(x),...
                   'tag','xslider',...
                   'callback', 'xslidercb'...
                   );
hxtext=uicontrol('style','text',...
                 'units', 'normalized',...
                 'position',[0.07 0.14 0.17 0.03],...
                 'tag','xtext',...
                 'string',['x= ' num2str(get(hxslider,'value'))]...
                 );

hxbtn=uicontrol('style','pushbutton',...
                'units','normalized',...
                'position',[0.07 0.05 0.17 0.037],...
                'string','slice X',...
                'callback','xbtncb'...
                );


hzslider=uicontrol('style', 'slider',...
                   'units', 'normalized',...
                   'position',[0.4 0.1 0.17 0.035],...
                   'min',min(z),...
                   'max',max(z),...
                   'value',min(z),...
                   'tag','zslider',...
                   'callback', 'zslidercb'...
                   );
hztext=uicontrol('style','text',...
                 'units', 'normalized',...
                 'position',[0.4 0.14 0.17 0.03],...
                 'tag','ztext',...
                 'string',['z= ' num2str(get(hzslider,'value'))]...
                 );
 
hzbtn=uicontrol('style','pushbutton',...
                'units','normalized',...
                'position',[0.4 0.05 0.17 0.037],...
                'string','slice Z',...
                'callback','zbtncb'...
                );

hyslider=uicontrol('style', 'slider',...
                   'units', 'normalized',...
                   'position',[0.7 0.1 0.17 0.035],...
                   'min',min(y),...
                   'max',max(y),...
                   'value',min(y),...
                   'tag','yslider',...
                   'callback', 'yslidercb'...
                   );
hytext=uicontrol('style','text',...
                 'units', 'normalized',...
                 'position',[0.7 0.14 0.17 0.03],...
                 'tag','ytext',...
                 'string',['y= ' num2str(get(hyslider,'value'))]...
                 );
 
hybtn=uicontrol('style','pushbutton',...
                'units','normalized',...
                'position',[0.7 0.05 0.17 0.037],...
                'string','slice Y',...
                'callback','ybtncb'...
                );

