function  seisrwb(x,t0,dt,g0,dg,nd,ss,sf)
%seisrwb(x,t0,dt,g0,dg,nd,ss,sf)
%
% Superimposed red-white-blue image of seismic section and 
% surface seismic wiggle plot with filled positive area.
% The seismic traces forming the columns of matrix X are plotted
% versus the time axis given by beginning time T0 and time interval DT.
% Time axis positive downwards.
% Horizontal distance axis starts at G0 and DG is the distance
% between each seismic trace.
% ND is the number of traces skipped between each plotted trace.
% T0, DT, G0, DG, ND are optional parameters with default values of
% T0=0, DT=1, G0=0, DG=1, ND=0.
% If only one trace is given (X has one column), it is repeated 25 times.
% SS Optional scale section or trace which controls the trace amplitudes.
% Traces are normalized by the maximum value of SS. Default is to normalize
% by the maximum value of X.
% SF is an optional scale factor which controls the amplitude scaling for 
% display. The default if nothing is given is 1.5

%Written by T. Mukerji

x=real(x);

if nargin<=7, sf=1.5; end; %default scale factor
if nargin<=6, ss=[]; end;  %default scale factor
if nargin<=5, nd=0; end;  %default nd
if nargin<=3, g0=0; dg=1; end;  %default g0, dg
if nargin==1, t0=0; dt=1; g0=0; dg=1; nd=0; end;

%if only one trace is given, then plot 25 traces here
if min(size(x))==1, x=x(:); x=x(:,ones(1,25)); end,

[nr, nc]=size(x);
g=g0:dg:g0+(nc-1)*dg;
 
%choose the traces needed to be plotted
  if nd ~= 0.
     y = x(:,1:nd:nc);
     g = g(1:nd:nc);
  else
    y=x;
  end

%imagesc(g,[t0:dt:t0+dt*(nr-1)],y),hold on;
pcolor(g,[t0:dt:t0+dt*(nr-1)],y),hold on; shading('interp');
seisplot(x,t0,dt,g0,dg,nd,ss,sf); hold off;

set(gca,'tickdir','out');

set(gca,'tag','seisplot');
