function seisplot(x,t0,dt,g0,dg,nd,ss,sf)
%seisplot(x,t0,dt,g0,dg,nd,ss,sf)
%
% Surface seismic wiggle plot with filled positive area
% of seismic traces forming the columns of matrix X versus the time
% axis given by beginning time T0 and time interval DT.
% Time axis positive downwards.
% Horizontal distance axis starts at G0 and DG is the distance
% between each seismic trace.
% ND is the number of traces skipped between each plotted trace.
% T0, DT, G0, DG, ND are optional parameters with default values of
% T0=0, DT=1, G0=0, DG=1, ND=0.
% If only one trace is given (X has one column), it is repeated 25 times.
% SS Optional scale section or trace which controls the trace amplitudes.
% Traces are normalized by the maximum value of SS. Default is to normalize
% by the maximum value of X.
% SF is an optional scale factor which controls the amplitude scaling for 
% display. The default if nothing is given is 1.5

% Written by Li Teng
% Modified T. Mukerji, 1998

if nargin<=7, sf=1.5; end; %default scale factor
if nargin<=6, ss=[]; end;  %default scale factor
if nargin<=5, nd=0; end;  %default nd
if nargin<=3, g0=0; dg=1; end;  %default g0, dg
if nargin==1, t0=0; dt=1; g0=0; dg=1; nd=0; end;

%if only one trace is given, then plot 25 traces here
[nr, nc]=size(x);
if ( (nr==1) | (nc==1) )
  [junk,x]=meshgrid(1:25,x);
end

[nr, nc]=size(x);
g=g0:dg:g0+(nc-1)*dg;

%choose the traces needed to be plotted
  if nd ~= 0.
     y = x(:,1:nd:nc);
     g = g(1:nd:nc);
  else
    y=x;
  end

%zero mean
m=mean(y);
y=y-m(ones(nr,1),:);

%normalize y by the biggest element
if ( (nargin==6) | (isempty(ss)) )
    nrm=max(max(y));
else
    mss=mean(ss); ss=ss-mss(ones(size(ss,1),1),:);
    nrm=max(max(ss));
end;
y=y./nrm; 

zw0 = y.*(y<0);  zw0(end+1:2*nr, :) = y(end:-1:1, :);
zwn = y.*(y>0);  zwn(end+1:2*nr, :) = y(end:-1:1, :);


i=1:size(y,2); scale=g; multscale=dg*sf;
% y(:,i)=y(:,i)-(i-1.)*0.5;  % for vsp
% z(:,i)=z(:,i)-(i-1.)*0.5;  % for vsp
%  y(:,i)=y(:,i)+(i-1.)*0.5; 
%  zw0(:,i)=zw0(:,i)+(i-1.)*0.5;
  y=multscale*y; 
  zw0=multscale*zw0;
  zwn=multscale*zwn;
  y=y+scale(ones(nr,1),:);  % vectorized version of the above two lines
  zw0=zw0+scale(ones(2*nr,1),:);
  zwn=zwn+scale(ones(2*nr,1),:);

ty=t0:dt:t0+(nr-1)*dt;
%tz(1)=t0;
%tz(2:nr+1)=ty;
%tz(nr+2)=tz(nr+1);
%tz=tz';
tz = ty';
ttz = tz; ttz(end+1:2*nr) = tz(end:-1:1);

%fill(tz,zw0,'w'), hold on
%plot(ty,y,'-w'), hold off
%xlabel('time');
%h=fill(zw0,tz,'b'); hold on;
h = fill(zw0, ttz, 'b'); hold on;
set(h,'edgecolor','none'); set(h,'tag','fillpos');
h = fill(zwn, ttz, 'r'); hold on;
set(h,'edgecolor','none'); set(h,'tag','fillneg'); set(h,'visible','off');
plot(y,ty,'-b'), hold off
set(gca,'ydir','reverse');
axis([scale(1,1) max(zw0(:,end)) tz(1) tz(end)]);
ylabel('time'); xlabel('distance');

set(gca,'tag','seisplot');
