function [w, dt] = ricker(f)
% [w, dt] = ricker(f)
% creates a Ricker wavelet, defined as the second derivative of a Gaussian
%
% inputs:
%    f  = desired center frequency of wavelet
%
% outputs:
%    w = output wavelet, with peak amplitude of 1
%        has an odd number of samples, so time zero is center value
%    dt = time sample interval

%  written by Gary Mavko, 5/01


dt = 0.065/f;
dt = 0.130/f;
a = 5*dt;
t = [-3*a: dt: 3*a];
w = -2.*((t./a).^2 - 0.5).*exp(-(t/a).^2);
