function lylim(yl)

if nargin <1,
	[x,yl] = ginput(2);
end;
h = findobj(gcf,'type','axes');
for k = 1:length(h)
    if ~strcmp(get(h(k),'tag'),'colorbar'),
	    ytcks = get(h(k),'YTick');
	    ylbls = get(h(k),'YTicklabel');
	    set(h(k),'ylim',yl);
	    if ~isempty(ylbls),
		    ind = ytcks >= min(yl) & ytcks <= max(yl);
	        set(h(k),'YTick',ytcks(ind));
            set(h(k),'YTicklabel',ylbls(ind,:));
        end;
    end;
end;
