function yout=fillnan(y,mode,val)
% yout=fillnan(y, mode, val);
% 
% Replaces nan with values, using one of four different algorithms
%
% inputs
%    y 		input vector, containing nans
%    mode   0 (default): uses interp1 and extrapolates outside of data range
%           1 uses interp1, but keeps nans outside of data range
%           2 substitutes fixed value into all nans
%           3 uses interpnext (nans filled with next non-nan value) and extrapolates outside the data range.
%    val    scalar value to use if mode=2; defaults to nanmean(y)

%  Gary Mavko  October 2002

if nargin < 1, warndlg('No input specified!'); end;
if nargin < 2, mode=0; end;
if length(y)==1, yout=y; return; end;
	
if mode==0,
    ifirst = min(find(~isnan(y)));
    ilast  = max(find(~isnan(y)));
    x = [1:length(y)]; if(size(y,1)>size(y,2)),x = x';end;
    if ifirst > 1,        y(1:ifirst-1) = y(ifirst); end;
    if ilast < length(y), y(ilast:end)  = y(ilast); end;
    yout = interp1(x(~isnan(y)), y(~isnan(y)), x);
elseif mode==1,
    x = [1:length(y)];
    yout = interp1(x(~isnan(y)), y(~isnan(y)), x);
elseif mode==2,
	if nargin < 3, val = nanmean(y);end;
    y(isnan(y))=val;
    yout=y;
elseif mode==3,
    ifirst = min(find(~isnan(y)));
    ilast  = max(find(~isnan(y)));
    x = [1:length(y)]; if(size(y,1)>size(y,2)),x = x';end;
    if ifirst > 1,        y(1:ifirst-1) = y(ifirst); end;
    if ilast < length(y), y(ilast:end)  = y(ilast); end;
    yout = interpnext(x(~isnan(y)), y(~isnan(y)), x);
else,
	warndlg('Incorrect Mode');
end;

