function arrow(xs, ys, xe, ye)

A = get(gcf,'position');                     % gets figure box size in pixels
B = get(gca, 'position');                    % gets axes size as fraction of figure
C = axis;                                    % axis limits in data space
xlen = A(3)*B(3);                            % axis xlength in pixels
ylen = A(4)*B(4);                            % axis ylength in pixels
xfact = xlen/(C(2)-C(1));                    % X pixels/data 
yfact = ylen/(C(4)-C(3));                    % Y pixels/data
delx = xe - xs;                              % arrow X-length in data space
delxp = delx*xfact;                          % arrow X-length in pixels
dely = (ye - ys);                            % arrow Y-length in data space
delyp = dely*yfact;                          % arrow Y-length in pixels

len = sqrt(delxp^2 + delyp^2)/4;             % arrow length in pixels
theta = atan2(delyp, delxp);
dx1 = cos(theta+.8*pi)*len/xfact;
dy1 = sin(theta+.8*pi)*len/yfact;
dx2 = cos(theta-.8*pi)*len/xfact;
dy2 = sin(theta-.8*pi)*len/yfact;

hold on;
plot([xs xe], [ys ye],'color', [.6 .6 .6],'linewidth',2);
hold on;
plot([xe xe+dx1], [ye ye+dy1],'color', [.6 .6 .6],'linewidth',2);
hold on;
plot([xe xe+dx2], [ye ye+dy2],'color', [.6 .6 .6]','linewidth',2);

