function [Vp,Vs,Ip,PR,RHOB,Phi,a]=StiffSand(Kf,RHOf,Phi,Quartz,Clay,Feldspar,Limestone,Dolomite,Pressure,PhiC,Coordination,Fudge)
%[Vp,Vs,Ip,PR,RHOB,Phi,a]=StiffSand(Kf,RHOf,Phi,Quartz,Clay,Feldspar,Limestone,Dolomite,Pressure,PhiC,Coordination,Fudge)
%Stiff sand model (implemented in Petrotools)
%
%				INPUTS
%
%Kf				Fluid bulk modulus
%RHOf			Fluid density
%Phi			Porosity (fraction)
%Quartz, etc.	Volume mineral content in solid phase (fraction)
%Pressure		Effective pressure (MPa)
%PhiC			Critical porosity ~0.4
%Coordination	Coordination number ~6
%Fudge			Reduction in shear stiffness -- 1 by default 
%
%               Outputs
%Vp, Vs, Ip, PR, RHOB, Phi: P & S velocities, P-impedance, Poisson's ratio
%                           bulk density, and porosity respectively
%a is the contact radius between two spheres at input pressure 

%Written by Jack Dvorkin 4/03


%Balancing mineralogy
Dolomite=1-(Quartz+Clay+Feldspar+Limestone);

%Solid-phase elastic moduli
KsV=Quartz*36.6+Clay*21+Limestone*76.8+Dolomite*94.9+Feldspar.*75.6;
KsR=1./(Quartz/36.6+Clay/21+Limestone/76.8+Dolomite/94.9+Feldspar./75.6);
Ks=0.5*(KsV+KsR);
GsV=Quartz*45+Clay*7+Limestone*32+Dolomite*45+Feldspar.*25.6;
GsR=1./(Quartz/45+Clay/7+Limestone/32+Dolomite/45+Feldspar./25.6);
Gs=0.5*(GsV+GsR);
Ms=Ks+(4/3)*Gs;
NUs=0.5*(Ms./Gs-2)./(Ms./Gs-1);

%Solid-phase density
RHOs=Quartz*2.65+Clay*2.58+Limestone*2.71+Dolomite*2.87+Feldspar.*2.63;


%ILLITE
%RHOs=2.58; Ms=RHOs.*4.32.*4.32; Gs=RHOs.*2.54.*2.54; NUs=0.5*(Ms./Gs-2)./(Ms./Gs-1); Ks=Ms-(4/3)*Gs;

P=Pressure./1000;
C=Coordination;

% ================== Dry Rock ====================
%Effective K and G at PhiC
%Hertz contact radius (R=1)
a=((3.*3.14.*(1-NUs)./(2.*C.*(1-PhiC).*Gs)).*P).^(1./3);
%Normal contact stiffness
SN=4.*a.*Gs./(1-NUs);
%Shear contact stiffness
ST=8.*a.*Gs./(2-NUs);
%Shear contact stiffbess FUDGED (reduced)
ST=ST./Fudge;
%Bulk modulus
Khat=C.*(1.-PhiC).*SN./(12.*3.14);
%Shear modulus
Ghat=C.*(1.-PhiC).*(SN+1.5.*ST)./(20.*3.14);

%Effective bulk and shear moduli at porosity Phi<PhiC:  UPPER MODIFIED H-S
KDry=1./((Phi./PhiC)./(Khat+4.*Gs./3)+((PhiC-Phi)./PhiC)./(Ks+4.*Gs./3))-4.*Gs./3;
ZZ=(Gs./6).*(9.*Ks+8.*Gs)./(Ks+2.*Gs);
GDry=1./((Phi./PhiC)./(Ghat+ZZ)+((PhiC-Phi)./PhiC)./(Gs+ZZ))-ZZ; 
MDry=KDry+(4./3).*GDry;
NuDry=0.5.*(MDry./GDry-2)./(MDry./GDry-1);
% ==============================================

% ================== Saturated Rock ============
KSat=Ks.*(Phi.*KDry-(1+Phi).*Kf.*KDry./Ks+Kf)./((1-Phi).*Kf+Phi.*Ks-Kf.*KDry./Ks);
MSat=KSat+(4/3)*GDry;
RHOB=(1-Phi).*RHOs+Phi.*RHOf;
Vp=sqrt(MSat./RHOB);
Vs=sqrt(GDry./RHOB);
Ip=Vp.*RHOB;
PR=0.5*(MSat./GDry-2)./(MSat./GDry-1);
