function runGandT(s1, s2, k1, k2, g1, g2, phic, colmap, imode)
% Uses G&T elastic-electrical cross bounds .  Pore space is phase 2
% superimposes K-C envelopes for many porosities, with Archie contours
% Inputs
%   s1,s2   conductivities
%   k1,k2   bulk moduli
%   g1,g2   shear moduli
%   phic    critical porosity
%  

% In this version, (S1,K1) and (S2,K2) refer to the doubly-coated sphere
% bounds, while (S5,K5) refers to the bound with three known realizable points.

% Generate vector of porosities for plotting smooth curves
phiplot = 10.^[0:.01:phic];
% Generate vector of porosities where each bound envelope will be computed
% phi = .06;
phi = fliplr([.005,.01,.015, .02,.03,.04,.05,.06,.07,.09,.11,.12,.14,.16,.18,.20,.22,.24,.26,.28, .30,.32, .35, .399]);
phi = fliplr([0.0922 0.1034 0.1065 0.1275 0.1286 0.1340 0.1374 0.1412 0.1439 0.1600 0.1652 0.1687 0.1744 0.1755 0.1881 0.1888 0.2899])
phi1 = logspace(-3,log10(1),40);
% set up colors for coding the porosity values
for j=1:length(phi)
    indcolr = round(64*phi(j)/phic);
    colr{j}=num2str(colmap(indcolr,:));
end;
titstr=['S1= ',num2str(s1,2),'; S2= ',num2str(s2,2),'; K1= ',num2str(k1,2),'; K2= ',num2str(k2,2),...
      '; G1= ',num2str(g1,2),'; G2= ',num2str(g2,2),'; Phic= ',num2str(phic,3)];

% Compute Modified Upper Bound on K and Modified Lower Bound on S to critical porosity phic
kreuss = 1./((1-phic)./k1 + phic/k2);
greuss = 0.;
% Generate vector of bulk moduli along a Modified Upper HS from mineral to Reuss
fc = phi/phic;
kdataUpper = 1./(fc/(kreuss+(4/3)*g1) + (1-fc)/(k1+(4/3)*g1)) -(4/3)*g1;
% Value of Conductivity at critical porosity on sHS2:
[~,sHS2c]=HSaverageCondB(1-phic,s1,s2);
% Modified lower bound from mineral to critical porosity value
[sdataLower,~]=HSaverageCondB(1-phi/phic,s1,sHS2c);

% % % figure; scatterqq(sdataLower/s2,phi,phi,[0 phic],jet); set(gca,'xscale','log')
% % % xlabel('S/Sfluid'); ylabel('porosity'); title('Modified bound on conductivity')
% % % box on; grid on; fsa20; msa8
% % % [KHS1,KHS2,~,~]=HSaverageB(1-phi,k1,k2,g1,g2);
% % % [SHS1,SHS2]    =HSaverageCondB(1-phi,s1,s2);
% % % figure; plot(SHS1/s2,KHS1/k1,SHS2/s2,KHS2/k1,SHS2/s2,KHS1/k1,SHS1/s2,KHS2/k1);

if imode==1, 
% For each porosity compute the G&T lens of cross-bounds.
    figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
    for j=1:length(phi)
        [kHS1,kHS2]=HSaverageB(1-phi(j),k1,k2,g1,g2);
        [sHS1,sHS2]=HSaverageCondB(1-phi(j),s1,s2)
        % Find the G&T envelopes of K and S for each porosity
        [S1,K1,S2,K2,~,~,~,~,S5,K5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
        S1n = (S1-sHS1)/(sHS2-sHS1);
        S2n = (S2-sHS1)/(sHS2-sHS1);
        S5n = (S5-sHS1)/(sHS2-sHS1);
        K1n = (K1-kHS2)/(kHS1-kHS2);
        K2n = (K2-kHS2)/(kHS1-kHS2);
        K5n = (K5-kHS2)/(kHS1-kHS2);
       
%         %  create vectors m, mplot, S1plot, and K1plot for later superimposing Archie's m
%         m = log10(S1)/log10(phi(j));
%         mplot(:,j)=m(:);
%         S1plot(:,j)=S1(:);
%         K1plot(:,j)=K1(:);
%         % Now, assume that there is a Modified Upper HS bound for K-porosity
%         % and truncate the G&T loops to that MUHS-Kvalue
%         Smin = interp1(K1,S1,kdataUpper(j));
%         K1 = min(kdataUpper(j),K1); 
%         K2 = min(kdataUpper(j),K2);
%         K5 = min(kdataUpper(j),K5);
%         S1 = max(Smin,S1); 
%         S2 = max(Smin,S2);
%         S5 = max(Smin,S5);
% 
        h=plot(S1n,K1n,S2n,K2n,S5n,K5n); set(h,'color',colr{j});
%         h=plot(S1/s2,K1/k1,S2/s2,K2/k1,S5/s2,K5/k1); set(h,'color',colr{j});
        set(h(1:2), 'Linewidth',2);
        set(h(3), 'linewidth',0.5);
    end;
    set(gca,'xscale','log'); xlim([1e-3,1]);
    fsa20; box on; grid on;
    title(titstr)
    colorbar; caxis([0 phic]); colormap( colmap)
end;

if imode==2, 
% For each porosity compute the Truncated G&T lens of cross-bounds.
    figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
    for j=1:length(phi)
        % Find the G&T envelopes of K and S for each porosity
        [S1,K1,S2,K2,S3,K3,S4,K4,S5,K5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
        length(S1)
        length(S2)
        length(S3)
        length(S4)
        length(S5)
        %  create vectors m, mplot, S1plot, and K1plot for later superimposing Archie's m
%         m = log10(S1)/log10(phi(j));
%         mplot(:,j)=m(:);
%         S1plot(:,j)=S1(:);
%         K1plot(:,j)=K1(:);
%         % Now, assume that there is a Modified Upper HS bound for K-porosity
%         % and truncate the G&T loops to that MUHS-Kvalue
%         Smin = interp1(K1,S1,kdataUpper(j));
%         K1 = min(kdataUpper(j),K1); 
%         K2 = min(kdataUpper(j),K2);
%         K5 = min(kdataUpper(j),K5);
%         S1 = max(Smin,S1); 
%         S2 = max(Smin,S2);
%         S5 = max(Smin,S5);
% 
'plotting'
        h=plot(S1/s2,K1/k1,S2/s2,K2/k1,S3/s2,K3/k1,S4/s2,K4/k1,S5/s2,K5/k1); set(h,'color',colr{j});
        set(h(1:2), 'Linewidth',2);
    end;
    set(gca,'xscale','log'); xlim([1e-3,1]);
    fsa20; box on; grid on;
    title(titstr)
    colorbar; caxis([0 phic]); colormap(colmap)
end;

if imode==3, 
% For each porosity compute the G&T lens of cross-bounds.
    figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
    for j=1:length(phi)
        % Find the G&T envelopes of K and S for each porosity
        [S1,K1,S2,K2,~,~,~,~,S5,K5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
        %  create vectors m, mplot, S1plot, and K1plot for later superimposing Archie's m
        m = log10(S1)/log10(phi(j));
        mplot(:,j)=m(:);
        S1plot(:,j)=S1(:);
        K1plot(:,j)=K1(:);
        % Now, assume that there is a Modified Upper HS bound for K-porosity
        % and truncate the G&T loops to that MUHS-Kvalue
        Smin = interp1(K1,S1,kdataUpper(j));
        K1 = min(kdataUpper(j),K1); 
        K2 = min(kdataUpper(j),K2);
        K5 = min(kdataUpper(j),K5);
        S1 = max(Smin,S1); 
        S2 = max(Smin,S2);
        S5 = max(Smin,S5);

        h=plot(S1/s2,K1/k1,S2/s2,K2/k1); set(h,'color',colr{j});
        set(h(1:2), 'Linewidth',2);
    end;
    set(gca,'xscale','log'); xlim([1e-3,1]);
    fsa20; box on; grid on;
    title(titstr)
    colorbar; caxis([0 phic]); colormap colmap
end;

if imode==4, 
% For each porosity compute the G&T lens of cross-bounds.
    figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
    for j=1:length(phi)
        % Find the G&T envelopes of K and S for each porosity
        [S1,K1,S2,K2,~,~,~,~,S5,K5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
        %  create vectors m, mplot, S1plot, and K1plot for later superimposing Archie's m
        m = log10(S1)/log10(phi(j));
        mplot(:,j)=m(:);
        S1plot(:,j)=S1(:);
        K1plot(:,j)=K1(:);
        % Now, assume that there is a Modified Upper HS bound for K-porosity
        % and truncate the G&T loops to that MUHS-Kvalue
        Smin = interp1(K1,S1,kdataUpper(j));
        K1 = min(kdataUpper(j),K1); 
        K2 = min(kdataUpper(j),K2);
        K5 = min(kdataUpper(j),K5);
        S1 = max(Smin,S1); 
        S2 = max(Smin,S2);
        S5 = max(Smin,S5);

%         h=plot(S1/s2,K1/k1,S2/s2,K2/k1,S5/s2,K5/k1); set(h,'color',colr{j});
        h=plot(S1/s2,K1/k1,S2/s2,K2/k1); set(h,'color',colr{j});
        set(h(1:2), 'Linewidth',2);
%         set(h(3), 'linewidth',0.5);
    end;
    set(gca,'xscale','log'); xlim([1e-3,1]);
    fsa20; box on; grid on;
    title(titstr)
    colorbar; caxis([0 phic]); colormap colmap
    % superimpose lines of constant Archie m
    mvect = [1.1, 1.2, 1.5, 2.0, 3.0, 4];
    for k=1:length(mvect)
        jjet=jet;
        ii = round(64*(mvect(k)-1)/(4-1));
    %     colr = jjet(ii,:);
        for j=1:length(phi)
            smplot(j) = interp1(mplot(:,j),S1plot(:,j),mvect(k));
            kmplot(j) = interp1(mplot(:,j),K1plot(:,j),mvect(k));
        end;
        smplot(isnan(kmplot))=[];kmplot(isnan(kmplot))=[];
        kmplot(isnan(smplot))=[];smplot(isnan(smplot))=[];
        plot(smplot/s2, kmplot/k1,'color','k','linewidth',3);
        text(smplot(1)/s2, kmplot(1)/k1,num2str(mvect(k)),'fontsize',12);
        clearvars smplot kmplot
    end;

    % For each porosity compute the cross-bounds.  Then, for the corresponding
    % kdata, the range of possible conductivities.  Plot lenses of
    % doubly-coated spheres
    figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
    for j=1:length(phi)
        [S1,K1,S2,K2,~,~,~,~,S5,K5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
        %  create vectors m, mplot, S1plot, and K1plot for later superimposing Archie's m
        m = log10(S1)/log10(phi(j));
        mplot(:,j)=m(:);
        S1plot(:,j)=S1(:);
        K1plot(:,j)=K1(:);
        % Now, assume that there is a Modified Upper HS bound for K-porosity
        % and truncate the G&T loops to that MUHS-Kvalue
        Smin = interp1(K1,S1,kdataUpper(j));
        K1 = min(kdataUpper(j),K1); 
        K2 = min(kdataUpper(j),K2);
        K5 = min(kdataUpper(j),K5);
        S1 = max(Smin,S1); 
        S2 = max(Smin,S2);
        S5 = max(Smin,S5);
        splot = [S1(:)/s2; flipud(S2(:))/s2];
        kplot = [K1(:)/k1; flipud(K2(:))/k1];
        h=fill(splot,kplot,'y');
        set(h,'edgecolor',colr{j},'facecolor',colr{j});
    end;
    set(gca,'xscale','log'); xlim([1e-3,1]);
    fsa20; box on; grid on;
    title(titstr)
    colorbar; caxis([0 phic]); colormap colmap
    % superimpose lines of constant Archie m
    mvect = [1.1, 1.2, 1.5, 2.0, 3.0, 4];
    for k=1:length(mvect)
        jjet=jet;
        ii = round(64*(mvect(k)-1)/(4-1));
    %     colr = jjet(ii,:);
        for j=1:length(phi)
            smplot(j) = interp1(mplot(:,j),S1plot(:,j),mvect(k));
            kmplot(j) = interp1(mplot(:,j),K1plot(:,j),mvect(k));
        end;
        smplot(isnan(kmplot))=[];kmplot(isnan(kmplot))=[];
        kmplot(isnan(smplot))=[];smplot(isnan(smplot))=[];
        plot(smplot/s2, kmplot/k1,'color','k','linewidth',3);
        text(smplot(1)/s2, kmplot(1)/k1,num2str(mvect(k)),'fontsize',12);
        clearvars smplot kmplot
    end;
end

return

% % % %-------------------------------------------------------------------------
% % % % For each porosity compute the cross-bounds.  Then, for the corresponding
% % % % kdata, the range of possible conductivities.  Plot lenses of
% % % % doubly-coated spheres.  Then add extra constraint of MUHS for K
% % % figure; hold on; xlabel('S/Sfluid'); ylabel('K/Kmin')
% % % for j=1:length(phi)
% % %     [S1,y1,S2,y2,S3,y3,S4,y4,S5,y5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
% % %     % Now, assume that there is a Modified Upper HS bound for K-porosity
% % %     % and truncate the G&T loops to that MUHS-Kvalue
% % %     Smin = interp1(y1,S1,kdataUpper(j));
% % %     % Now, assume that there is a Modified Upper HS bound for K-porosity
% % %     % and truncate the G&T loops to that MUHS-Kvalue
% % %     y1 = min(kdataUpper(j),y1); 
% % %     y2 = min(kdataUpper(j),y2);
% % %     y5 = min(kdataUpper(j),y5);
% % %     S1 = max(Smin,S1); 
% % %     S2 = max(Smin,S2);
% % %     S5 = max(Smin,S5);
% % %     splot = [S1(:)/s2; flipud(S2(:))/s2];
% % %     kplot = [y1(:)/k1; flipud(y2(:))/k1];
% % %     h=fill(splot,kplot,'y');
% % %     set(h,'edgecolor',colr{j},'facecolor',colr{j})
% % % end;
% % % set(gca,'xscale','log'); xlim([1e-3,1]);
% % % fsa20; box on; grid on;
% % % title(titstr)
% % % colorbar; caxis([0 phic]); colormap colmap
% % % mvect = [1.2 1.5 2.0, 3.0, 4];
% % % for k=1:length(mvect)
% % %     jjet=jet;
% % %     ii = round(64*(mvect(k)-1)/(4-1))
% % %     colr = jjet(ii,:)
% % %     clear smplot kmplot
% % %     for j=3:length(phi)-3
% % %         smplot(j) = interp1(mplot(:,j),S1plot(:,j),mvect(k));
% % %         kmplot(j) = interp1(mplot(:,j),K1plot(:,j),mvect(k));
% % %         kdataUpperplot(j) = kdataUpper(j);
% % %     end;
% % %     
% % %     plot(smplot/s2, kmplot/k1,'color',colr,'linewidth',3);
% % %     
% % %     length(phi)-3
% % %     size(smplot)
% % %     size(kdataUpper)
% % %     size(kdataUpper(3:length(phi)-3))
% % %     plot(smplot/s2, kdataUpperplot/k1,'color',colr,'linewidth',3);
% % %     clear smplot kmplot
% % % end;

% % % %-------------------------------------------------------------------------
% % % % For each porosity compute the cross-bounds.  Then, for the corresponding
% % % % kdata, the range of possible conductivities.
% % % figure; hold on; xlabel('K/Kmin'); ylabel('(S/Sfluid)/(K/Kmin)')
% % % for j=1:length(phi)
% % %     [S1,y1,S2,y2,S3,y3,S4,y4,S5,y5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
% % %     h=plot(y1/k1,(S1/s2)./(y1/k1),  y2/k1,(S2/s2)./(y2/k1),  y3/k1,(S3/s2)./(y3/k1),  y4/k1,(S4/s2)./(y4/k1),  y5/k1,(S5/s2)./(y5/k1));
% % %     set(h(1:2), 'Linewidth',2);
% % %     set(h(3:5), 'visible','off');
% % %     text(min(y1/k1),max((S1/s2)./(y1/k1)),num2str(phi(j)))
% % %     soutUpper1(j) = interp1(y1,S1,kdataUpper(j));
% % %     soutUpper2(j) = interp1(y2,S2,kdataUpper(j));
% % %     soutUpper3(j) = interp1(y3,S3,kdataUpper(j));
% % %     soutUpper4(j) = interp1(y4,S4,kdataUpper(j));
% % %     soutUpper5(j) = interp1(y5,S5,kdataUpper(j));
% % % end;
% % % set(gca,'xscale','log'); xlim([1e-4,1]);
% % % fsa16
% % % title(titstr)
%-------------------------------------------------------------------------

% % % figure;
% % % h=plot(phi, soutUpper1/s2,'-k',phi,soutUpper2/s2,'-k',phi,soutUpper3/s2,'--k',phi,soutUpper4/s2,'--k',phi,soutUpper5/s2,'--k');
% % % set(h,'linewidth',2,'color','k');
% % % xlabel('porosity'); ylabel('1/F')
% % % hold on;
% % % H=plot(phi,phi.^1.6,'-m',phi,phi.^1.8,'-r',phi,phi.^2,'-b',phi,phi.^2.2,'-g');
% % % set(H,'linewidth',1)
% % % legend([H;h],'Archie m=1.6','      m=1.8','      m=2','      m=2.2','GT bound 1','GT bound 2','GT bound 3','GT bound 4','GT bound 5')
% % % fsa16
% % % title(titstr);set(gca,'titlefontsizemultiplier',.8,'titlefontweight','normal');
% % % 
% % % % %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% % % % % Do it again.  Now specify conductivity and solve for range of bulk moduli
% % % % 
% % % phi = [.01:.01:.99];
% % % 
% % % sdataArchie = s2*(phi.^m);
% % % % % % figure; plot(phi,sdataArchie); xlabel('porosity');ylabel('Conductivity');
% % % % For each porosity compute the cross-bounds.  Then, for the corresponding
% % % % Sdata, the range of possible bulk moduli.
% % % for j=1:length(phi)
% % %     [S1,y1,S2,y2,S3,y3,S4,y4,S5,y5] = gibiansky_torquato_crossbounds(1-phi(j), phi(j), s1, s2, k1, k2, g1, g2);
% % %     kout1(j) = interp1(S1,y1,sdataArchie(j));
% % %     kout2(j) = interp1(S2,y2,sdataArchie(j));
% % %     kout3(j) = interp1(S3,y3,sdataArchie(j));
% % %     kout4(j) = interp1(S4,y4,sdataArchie(j));
% % %     kout5(j) = interp1(S5,y5,sdataArchie(j));
% % % end;
% % % khsu = 1./(phi./(k2+(4/3)*g1) + (1-phi)./(k1+(4/3)*g1))-(4/3)*g1;
% % % khsl = 1./(phi./(k2+(4/3)*g2) + (1-phi)./(k1+(4/3)*g2))-(4/3)*g2;
% % % 
% % % figure;
% % % h=plot(phi, kout1,'-k',phi,kout2,'-k',phi,kout3,'--k',phi,kout4,'--k',phi,kout5,'--k');
% % % set(h,'linewidth',2,'color','k');
% % % xlabel('porosity'); ylabel('K')
% % % hold on;
% % % plot(phi,khsu,phi,khsl)
% % % title(titstr);set(gca,'titlefontsizemultiplier',.8,'titlefontweight','normal');
% % % phic = 0.42;
% % % % Generate vector of bulk moduli along a mondified upper HS from mineral to Reuss
% % % phi = [.01:.01:phic];
% % % f = phi/phic;
% % % kreussplot = 1./(phic/k2 + (1-phic)/k1);
% % % kplotUpper = 1./(f/(kreussplot+(4/3)*g1) + (1-f)./(k1+(4/3)*g1)) - (4/3)*g1;
% % % H=plot(phi,kplotUpper);  set(H,'linewidth',1)
% % % fsa16
% % % title(titstr);set(gca,'titlefontsizemultiplier',.8,'titlefontweight','normal');
% % % legend('GT bound 1','GT bound 2','GT bound 3','GT bound 4','GT bound 5','KHS+','KHS-','MUHS')



