
function [sel] = radiodlg(prompt, stringlist, defvals)
% [sel] = radiodlg(prompt, stringlist)
%
% Constructs an input dialog composed of a list of radio buttons.
%
% prompt        Cell array containing a single string, placed at the top to prompt user
% stringlist    Cell array containing an arbitrary number of button labels
% defvals       array of item numbers to default as selected.  
%               Leave blank if no buttons are defaulted
%               e.g.:   defvals=[2,3] means button number 2 and 3 are defaulted as on
%
% sel           array of indices that have been chosen.   =[] if none chosen or if cancel
%               is hit
%
% Example:    [sel]=radiodlg({'who will you invite to the party?'}, {'Bob','Carol','Ted','Alice'})

% gary mavko   Dec 2004

nitems = length(stringlist);
if nargin < 3, 
    vals = zeros(nitems,1); 
else,
    if prod(defvals)<=0, warndlg('defvals must be nonzero indices of buttons'); return; end;
    vals = zeros(nitems,1); vals(defvals)=1;
end;

% determine figure dimensions, according to input string
ls=0; for k=1:length(stringlist); ls=max(ls,length(stringlist{k})); end;      %number of characters in longest string
lp = length(prompt{1});                                                    %number of characters in prompt
l = max(ls,lp);                                                            %maximum number of characters to accommodate

p3 = max(210, 50 + l*6);
p4 = 55 + nitems*35 + 50;
b3 = max(160,  l*6);

% overall figure
h0 = figure('Color',[0.8 0.8 0.8], ...
	'PaperPosition',[18 180 576 432], ...
	'PaperUnits','points', ...
	'Position',[533 200 p3 p4], ...
	'Tag','Fig1', ...
        'Name','Radio button list',...
        'menubar','none');
    
uicontrol('style','frame', ...
          'position',[5 5 p3-10 35]);
uicontrol('style','frame', ...
          'position',[5 45 p3-10 p4-55]);

% construct a button for each item in stringlist
for k = 1:nitems,
  hlb(k) = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[1 1 1], ...
	'Position',[20 55+(nitems-k)*35 b3 25], ...
	'String',stringlist{k}, ...
    'horizontalalignment','left', ...
	'Style','radiobutton', ...
	'Tag',[num2str(k)], ...
    'value',vals(k), ...
    'visible','on');
end;

% construct cancel button
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7 0.7 0.7], ...
	'ListboxTop',0, ...
	'Position',[20 10 80 20], ...
	'String','Cancel', ...
    'callback','set(gcf,''userdata'',0)', ...
	'Tag','Pushbutton1');

% construct ok button
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.7 0.7 0.7], ...
	'ListboxTop',0, ...
	'Position',[20+b3-80 10 80 20], ...
	'String','OK', ...
        'callback','set(gcf,''userdata'',1)', ...
	'Tag','Pushbutton1');

% put prompt string at the top
h1 = uicontrol('Parent',h0, ...
	'Units','points', ...
	'BackgroundColor',[0.8 0.8 0.8], ...
	'ListboxTop',0, ...
	'Position',[20 55+nitems*35 b3 15], ...
	'String',prompt{1}, ...
	'Style','text', ...
    'horizontalalignment','left', ...
	'Tag','StaticText1');
if nargout > 0, fig = h0; end

waitfor(h0,'userdata');

sel=[];
if get(h0,'userdata')==1,
    for k = 1:nitems,
        val = get(hlb(k),'value');
        if val==1,
            sel(end+1) = k;
        end;
    end;
end;
            
delete(h0);
