function  y=interpnext(x1, y1, x)
% y = interpnext(x1, y1, x)
%
% interpolation, similar to interp1, except that it uses the 'next' option.
% For desired new sample at x, the input function is sampled at the next sample x1
% greater or equal to x
% Method alters input data, by turning each point into a pair, so that normal
% interpolation is fooled.

% Gary Mavko

dx = max(100*eps,mean(diff(x1))*1e-06);

x1(end) = max(x1(end),max(x) + dx);
y1(end+1) = y1(end);
n1 = length(x1);
n  = length(x);

xx1(1:2:2*n1-1) = x1;
xx1(2:2:2*n1)   = x1+dx;
yy1(1:2:2*n1-1) = y1(1:end-1);
yy1(2:2:2*n1)   = y1(2:end);

y = interp1(xx1,yy1,x);
