function find_dependencies(S,n)
%  find_dependencies(S)
% finds up to four levels of functions that S depends on
% inputs:
%    S is a string variable containing name of function to search.  e.g.'plot.m'
%    n (optional) is the number of levels to search; n<=4

if nargin>1, if n>4, n=4; 'Won''t search past level 4', end; end;
if nargin<2, 
    sel=inputdlg({'How many levels of dependencies <=4 ?'},'Dependencies',1,{'2'});
    n=str2num(sel{1});
    if n>4, n=4; 'Won''t search past level 4',end;
end;

blank='    ';
arr  ='--> ';
fprintf('\n%s\n',S)

% find first level of functions that S depends on
outlevel1 = seek(S);
for k=1:length(outlevel1),   % loop over first level of functions and find next
    fprintf('%s%s\n',arr,outlevel1{k})  
    if n>=2,
        % find 2nd level of functions 
        
        outlevel2 = seek(outlevel1{k});
        if ~isempty(outlevel2), 
            for j=1:length(outlevel2), 
                fprintf('%s%s%s\n',blank,arr,outlevel2{j}); 
                if n>=3,
                    % find 3rd level of functions
                    
                    outlevel3 = seek(outlevel2{j});
                    if ~isempty(outlevel3), 
                        for l=1:length(outlevel3)
                            fprintf('%s%s%s%s\n',blank,blank,arr,outlevel3{l});
                            if n>=4
                                
                                outlevel4 = seek(outlevel3{l});
                                if ~isempty(outlevel4),
                                    for i=1:length(outlevel4)
                                        fprintf('%s%s%s%s%s\n',blank,blank,blank,arr,outlevel4{l}); 
                                    end;
                                end;
                            end;
                        end;
                    end;
                end;
            end; 
        end;
    end;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function output = seek(S)
% output = seek(S)
% Finds one level of dependencies of function S
% inputs:
%    S      function name, character string
%    output cell array of functions that S calls

output ={};
% find full pathnames of functions that S depends on. fList is cell array
[fList,~] = matlab.codetools.requiredFilesAndProducts(S);
% strip path from 
icount = 0;
for k=1:length(fList)
    % strip path and only retain function name
    fnamek = split(fList{k},'/');
    fnamek = fnamek{end};
    if ~strcmp(fnamek,S), icount=icount+1; output{icount}=fnamek;end;
end;


