function yout=fillnan(y,mode,val)
% yout=fillnan(y, mode, val);
% 
% Replaces nan with values, using one of five different algorithms
%
% inputs
%    y 		input vector, containing nans
%    mode   0 (default): uses interp1 in gaps;continues end points outside of data range
%           1 uses interp1, but keeps nans outside of data range
%           2 substitutes fixed value into all nans
%           3 uses interpnext (nans filled with next non-nan value) and extrapolates outside the data range.
%           4 uses interp1 in gaps; extrapolates end points along straight lines, with average slope of the data
%    val    scalar value to use if mode=2; defaults to nanmean(y)

%  Gary Mavko  October 2002

if nargin < 1, warndlg('No input specified!'); end;
if nargin < 2, mode=0; end;
if length(y)==1, yout=y; return; end;
	
if mode==0,  
    % indices of first and last non-nan numbers;
    ifirst = find(~isnan(y), 1, 'first' );
    ilast  = find(~isnan(y), 1, 'last' );
    x = [1:length(y)]; if(size(y,1)>size(y,2)),x = x';end;
    % continue first and last non-nan values beyond data range
    if ifirst > 1,        y(1:ifirst-1) = y(ifirst); end;
    if ilast < length(y), y(ilast:end)  = y(ilast); end;
    % interpolate internal nan gaps
    yout = interp1(x(~isnan(y)), y(~isnan(y)), x);
elseif mode==1,
    % interpolate internal nan gaps
    x = [1:length(y)];
    yout = interp1(x(~isnan(y)), y(~isnan(y)), x);
elseif mode==2,
	if nargin < 3, val = nanmean(y);end;
    y(isnan(y))=val;
    yout=y;
elseif mode==3,
    % indices of first and last non-nan numbers;
    ifirst = find(~isnan(y), 1, 'first' );
    ilast  = find(~isnan(y), 1, 'last' );
    x = [1:length(y)]; if(size(y,1)>size(y,2)),x = x';end;
    % continue first and last non-nan values beyond data range
    if ifirst > 1,        y(1:ifirst-1) = y(ifirst); end;
    if ilast < length(y), y(ilast:end)  = y(ilast); end;
    % interpolate internal nan gaps
    yout = interpnext(x(~isnan(y)), y(~isnan(y)), x);
elseif mode==4,
    leny = length(y);
    % interpolate internal data gaps
    x = [1:leny];
    yout = interp1(x(~isnan(y)), y(~isnan(y)), x);
    % indices of first and last non-nan numbers
    ifirst = find(~isnan(y), 1, 'first' );
    ilast  = find(~isnan(y), 1, 'last' );
    % average slope between first and last non-nan numbers
    slope = (y(ilast)-y(ifirst))/(ilast-ifirst);
    % extrapolate end points using same slope
    if ifirst > 1,         yout(1:ifirst-1)   = yout(ifirst)-slope*[ifirst-1:-1:1]; end;
    if ilast  < length(y), yout(ilast+1: end) = yout(ilast) + slope*[1: leny-ilast]; end;
else
	warndlg('Incorrect Mode');
end;

