function yprime=demyprimeN_cond_aligned(t,y)
% function yprime=demyprimeN_cond_aligned(t,y)
% This is only called by function   cond_aligned_inclusion_dem.m
%
% Calculates macroscopic effective electrical conductivity of VTI anisotropic composites 
% with VTI spheroidal inclusions sitting in a VTI background, using DEM.
% Axis of symmetry of background conductivity,
% inclusion conductivity, and spheroid shape are all aligned with the X3 axis. 
% Can have multiple inclusions, each with its own aspect ratio but with
% same inclusion fill material.

% Written by G. Mavko

global DEMINPT;

condB   = DEMINPT.condB;   % background material conductivity
condI   = DEMINPT.condI;   % inclusion material conductivity
asp     = DEMINPT.asp;     % aspect ratio
frac    = DEMINPT.frac;   % volume portion of each inclusion type

% background conductivity, which varies with each increment of inclusion
C = [y(1) 0 0; 0 y(2) 0; 0 0 y(3)];
  
% compute electric field concentration factors for each of the inclusion
% types

Crhs = zeros(3,3);
CI = [condI(1) 0 0; 0 condI(2) 0; 0 0 condI(3)];
for j=1:length(frac),
    R    = Rfactor_aniso(y, condI,asp(j));
    Crhs = Crhs +frac(j)*(CI-C)*R;
end;

Crhs=Crhs/(1-t) ;
yprime = [Crhs(1,1), Crhs(2,2), Crhs(3,3)];
