function [Condeff]=cond_iso_inclusion_scmB(Cond,asp,fracs)
%condscm - Effective electrical conductivity for multi-component ISOTROPIC composite
% [Condeff]=cond_iso_inclusion_scm(Cond,asp,frac)
% ** can also be directly applied to DIELECTRIC CONSTANT instead of CONDUCTIVITY
%
% Effective ELECTRICAL CONDUCTIVITY for ISOTROPIC composite of SPHEROID
% inclusions using the SELF CONSISTENT METHOD method (SCM) .
% This version allows multiple spheroid constituents.
%	Cond:      Conductivity of the N constituent phases (vector of length N)
%              Each phase is isotropic and has a scalar conductivity.
%	asp:       Vector of aspect ratios for each of the N constituents
%			  < 1 for oblate spheroids; 
%   fracs:     Volume fraction of each phase. Sum(fracs)=1
%	Condeff:   Scalar Effective conductivity 
%
% Earlier version found the solution by making a vector of 1000 guesses
% spanning between the extreme constituent conductivities.  Then "best"
% solution was the one with the minimum objective function.   This version
% instead uses the function     fminbnd.m    which finds the minimum
% continuously.
% Equation to solve is:    SUM(fracs*(Condi - Condeff)*Ri=0;

% Written by Nishank Saxena (Shell) (2016)
%  modified by Gary Mavko
%

global Condglobal aspglobal fracsglobal 
Condglobal=Cond;
aspglobal=asp;
fracsglobal=fracs;

% Validate inputs
if length(Cond) ~= length(asp) | length(Cond) ~= length(fracs),
    'input vectors Cond, asp, and frac must all have the same lengths'
    return;
end;
if abs(sum(fracs)-1)>.00001,
    'sum of fractions not equal to 1; Normalizing'
    fracs = fracs/sum(fracs);
end;


% Solve the problem
% in the FMINBND function: 
%    Condeff is the effective conductivity:  the desired answer in the optimization:  
%    function deltacond contains the Equation to minimize:  SUM(fracs*(Condi - Condeff)*Ri=0;
%    min(Cond) and max(Cond) define the range of solutions
[Condeff,Fval,exitflag] = fminbnd(@(Condeff) deltacond(Condeff),min(Cond),max(Cond));
if exitflag~=1, 'Cannot find a solution', end;

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function X=deltacond(C)
% 
global Condglobal aspglobal fracsglobal 
% 
% find the Field Concentration Factor R of each inclusion in the effective
% background conductivity
for i = 1:length(aspglobal)
    [R(i)] = Rfactor_cond_iso(C, Condglobal(i),aspglobal(i));
end
X = abs(sum(fracsglobal.*(Condglobal - C).*R));






