function [CondE, por]=cond_aligned_inclusion_dem(condB,condI,frac,asp)
% % VTI Electrical conductvity (Shafiro and Kachanov, 2000; Torquato, 2002;
% Apresyan and Vlosov, 2014)
% Calculates macroscopic effective electrical conductivity of VTI anisotropic composites 
% with VTI spheroidal inclusions sitting in a VTI background, using DEM.
% Axis of symmetry of background conductivity,
% inclusion conductivity, and spheroid shape are all aligned with the X3 axis. 
% Can have multiple inclusions, each with its own aspect ratio but with
% same inclusion fill material.
%
% Inputs: 
%    condB = Background principal conductivities in the form [CondB1 CondB2 CondB3]
%    condI = Inclusion  principal conductivities in the form [CondI1,CondI2,CondI3]
%    frac  = Vector:  portion of total porosity occupied by each inclusion;sum(frac)=1
%    asp   = Vector of N spheroid aspect ratios.  asp<1 is oblate
% Output: 
%    CondE = Effective principal conductivities in the form [CondE1 CondE2 CondE3]
%    por   = porosities where Conductivities are computed

% Written by Gary Mavko

% Check validity of inputs
if size(condB) ~= [1,3],
    'condB must be a [1,3] row vector'
    return;
end;
if size(condI) ~= [1,3],
    'condB must be a [1,3] row vector'
    return;
end;
if length(frac) ~= length(asp) ,
    'input vectors asp and frac must have the same lengths'
    return;
end;
if sum(frac) ~=1,
    'frac must sum to 1; normalizing'
end;

global DEMINPT;

DEMINPT.condB = condB;   % background material conductivity
DEMINPT.condI = condI;   % inclusion material conductivity
DEMINPT.asp   = asp  ;   % aspect ratios
DEMINPT.frac  = frac;   % porosities of each inclusion type

% integrate the ODE of conductivity vs. porosity
[por, CondE]=ode45m('demyprimeN_cond_aligned',0.00,0.99999,condB,max([condB,condI])*1e-15);

% plot result if there are no outputs specified.
if nargout==0
   figure; plot(por,CondE(:,1),'-g','linewidth', 1);
   hold on; plot(por,CondE(:,2),'-g','linewidth', 1);
   hold on; plot(por,CondE(:,3),'-g','linewidth', 1);
end;
clear DEMINPT;

