 function [cond_out,eps_out,cond_outnp,eps_outnp,fgrain]=cond_Bruggeman_polarized(reps_fluid,rcond_fluid,reps_grain,rcond_grain,a,phi,f,T,q)
%
%
%[K,MU,POR]=DEM(K1,MU1,K2,MU2,ASP,PHIC)
%
%	K1, MU1:	Bulk and shear moduli of background matrix
%	K2, MU2:	Bulk and shear moduli of inclusions
%	ASP:		Aspect ratio of inclusions
%			<1 for oblate spheroids; >1 for prolate spheroids
%	PHIC:		percolation porosity for modified DEM model
%			=1 for usual DEM
%	K, MU:		Effective bulk and shear moduli
%	POR:		Porosity, fraction of phase 2.
%			For the modified DEM, where phase two is the
%			critical phase, POR is the actual porosity.


global DEMINPT;
DEMINPT=ones(1,1);

% ***Physical constants***:
% permittivity in free space
eps0 = 8.854187817e-12;    % F/m
% absolute charge of an electron
e = 1.60217662e-19;    % Coulombs
% Boltzman constant
k = 1.38065e-23 ;   % m^2.kg.s^-2.K^-1
% typical ionic diffusivity
D = 2e-9;  % m^2/s
% % % % surface charge density
% % % q=0.0062;    % C/m^2
omega = 2*pi*f;
i=sqrt(-1);
% complex conductivities:
cond_fluid = rcond_fluid + i*omega*eps0*reps_fluid;
cond_grain = rcond_grain + i*omega*eps0*reps_grain;
eps_fluid  = cond_fluid/(i*omega)/eps0;
eps_grain  = cond_grain/(i*omega)/eps0;

lamda = sqrt(i*omega/D);
J1 = 1 + lamda*a;
J2 = 1 + J1^2;

%  double layer thickness
hD = sqrt(eps0*reps_fluid*D/rcond_fluid);    % eqn 5
% Maxwell-Wagner frequency
fMW = D/(2*pi*hD^2);    % page 2
fion = D/(2*pi*a^2);

% the zeta potential is a measure of the charge density with no field applied
zeta = (2*k*T/e)*asinh(e*q*hD/(2*eps0*reps_fluid*k*T));   % eqns 55 & 56

% parallel conductivity in double layer
cond_par = (2*rcond_fluid*hD/a)*(exp(e*abs(zeta)/(2*k*T))-1);  % eqn 4
% dipolar coefficient
beta = (cond_grain -   cond_fluid + cond_par*(1 -   J1/J2))/ ...
       (cond_grain + 2*cond_fluid + cond_par*(1 + 2*J1/J2));      % eqn 7

DEMINPT=beta;
%  OPTIONS = odeset('RelTol',1e-3);
% [fgrain, cond_eff]=ode113('demyprime_cond_cmplx',[0,1-phi],cond_fluid,OPTIONS);
[fgrain, cond_eff]=ode45m('demyprime_cond_cmplx',0,1-phi,cond_fluid);

% effective conductivity
% % cond_eff = yout;
cond_eff=cond_eff(end);
eps_eff  = (cond_eff/(i*omega))/eps0;
cond_out = real(cond_eff);
eps_out  = real(eps_eff);
cond_outnp = cond_out;
eps_outnp  = eps_out;
clear DEMINPT;

