function [Ksat,Gsat] = Solidsub(phi,Kdry,Gdry,Kb,Gb,Kf,Gf)
% [Ksat,Gsat] = Solidsub(phi,Kdry,Gdry,Kb,Gb,Kf,Gf)

% Solid substitution using the lower embedded bound - generalized Gassmann
% Predicts the "smallest" possible change in rock stiffness upon substitution
% (Saxena and Mavko, 2014) and (Mavko and Saxena, 2013)

% Inputs
% phi: porosity (volume fraction of pore-fill)
% Kdry and Gdry: dry rock bulk (K) and shear (G) moduli
% Kb and Gb: Mineral in the rock frame bulk (K) and shear (G) moduli
% Kf and Gf: Pore-fill bulk (K) and shear (G) moduli

% Outputs
% Ksat and Gsat: saturated rock bulk (K) and shear (G) moduli

% Written by Nishank Saxena

Kzb = ((1-phi).*(1./Kb - 1./Kdry) + (3.*phi./4).*(1./Gb - 1./Gf))./( (1./Kb).*(1./Kb - 1./Kdry) + (3.*phi./4).*(1./(Kb.*Gb) - 1./(Gf.*Kdry)));
Ksat = (Kf.*Kb.^2 - Kf.*Kb.*Kzb + Kb.^2.*Kzb.*phi - Kf.*Kb.*Kzb.*phi)./(Kb.^2.*phi + Kf.*Kb - Kf.*Kzb - Kf.*Kb.*phi);

Gbc = (((1-phi).*(1./Gb - 1./Gdry) + phi.*(1./((Gb./6).*(9.*Kb + 8.*Gb)./(Kb + 2.*Gb)) - 1./((Gf./6).*(9.*Kf + 8.*Gf)./(Kf + 2.*Gf))))./((1./Gb).*(1./Gb - 1./Gdry) + phi.*(1./(Gb.*((Gb./6).*(9.*Kb + 8.*Gb)./(Kb + 2.*Gb))) - 1./(((Gf./6).*(9.*Kf + 8.*Gf)./(Kf + 2.*Gf)).*Gdry))));
Gsat = (Gf.*Gb.^2 - Gf.*Gb.*Gbc + Gb.^2.*Gbc.*phi - Gf.*Gb.*Gbc.*phi)./(Gb.^2.*phi + Gf.*Gb - Gf.*Gbc - Gf.*Gb.*phi);


end

