function [Kuf,Guf] = Solidsquirt_uf(phic,Khdry,Ghdry,Kdry,Gdry,Kb,Gb,Kf,Gf)
% [Kuf,Guf] = Solidsquirt_uf(phic,Khdry,Ghdry,Kdry,Gdry,Kb,Gb,Kf,Gf)

% Solid-squirt unrelaxed dry frame bulk and shear moduli (Saxena and Mavko, 2014)
% soft pores filled with pore-solid and stiff dry pores

% Inputs
% phic: soft porosity
% Khdry and Ghdry: High pressure dry rock bulk (K) and shear (G) moduli
% Kdry and Gdry: Low pressure dry rock bulk (K) and shear (G) moduli
% Kb and Gb: Mineral in the rock frame bulk (K) and shear (G) moduli
% Kf and Gf: Pore-fill bulk (K) and shear (G) moduli

% Outputs
% Kuf and Guf: unrelaxed dry frame bulk (K) and shear (G) moduli

% Written by Nishank Saxena


Mb = Kb + (4/3)*Gb;
Bb = Gb*(3*Kb + Gb)/(3*Kb + 4*Gb);
Xb = ((Gb/6)*(9*Kb + 8*Gb)/(Kb + 2*Gb));
Nb = (8*Gb/(Gb + 2*Bb) + (4/3)*(Gb/Bb));
Fb = Gb + Xb;
Kh = Khdry;
Gh = Ghdry;
Kdry = Kdry;
Gdry = Gdry;
Ka = Kf; Ga = Gf;

Xb = ((Gb/8)*(9*Kb + 8*Gb)/(Kb + 2*Gb));
Xf = ((Gf/8)*(9*Kf + 8*Gf)/(Kf + 2*Gf));

sBndry = 1/Kdry - 1/Kh;
sBn = (Gb*phic*sBndry*(Kb - Kf)*(4*Gf + 3*Kb))/(Kb*(3*Gb*Kb*phic - 3*Gb*Kf*phic - 3*Gf*Kb*phic + 3*Gf*Kf*phic + 4*Gb*Gf*Kb*sBndry + 3*Gb*Kb*Kf*sBndry - 4*Gb*Gf*Kb*phic*sBndry + 4*Gb*Gf*Kf*phic*sBndry));

sCtdry = 1/Gdry - 1/Gh - (4/15)*sBndry;
sCt = (Xb*phic*sCtdry*(Gb - Gf)*(4*Xf + 3*Gb))/(Gb*(3*Xb*Gb*phic - 3*Xb*Gf*phic - 3*Xf*Gb*phic + 3*Xf*Gf*phic + 4*Xb*Xf*Gb*sCtdry + 3*Xb*Gb*Gf*sCtdry - 4*Xb*Xf*Gb*phic*sCtdry + 4*Xb*Xf*Gf*phic*sCtdry));

Guf = 1/((4*sBn)/15 - (4*sBndry)/15 + sCt - sCtdry + 1/Gdry);
Kuf = 1/(sBn + 1/Kh);

end

