function [Ksat,Gsat] = Solidsquirt(phi,phic,Khdry,Ghdry,Kdry,Gdry,Kb,Gb,Kf,Gf)
% [Ksat,Gsat] = Solidsquirt(phi,phic,Khdry,Ghdry,Kdry,Gdry,Kb,Gb,Kf,Gf)

% Solid-squirt: saturated rock bulk and shear moduli (Saxena and Mavko, 2014)

% Inputs
% phi: stiff porosity
% phic: soft porosity
% Khdry and Ghdry: High pressure dry rock bulk (K) and shear (G) moduli
% Kdry and Gdry: Low pressure dry rock bulk (K) and shear (G) moduli
% Kb and Gb: Mineral in the rock frame bulk (K) and shear (G) moduli
% Kf and Gf: Pore-fill bulk (K) and shear (G) moduli

% Outputs
% Ksat and Gsat: saturated rock bulk (K) and shear (G) moduli

% Written by Nishank Saxena

Kh = Khdry;
Gh = Ghdry;
Kdry = Kdry;
Gdry = Gdry;
Ka = Kf; Ga = Gf;
phin = phi - phic;
Xb = ((Gb/8)*(9*Kb + 8*Gb)/(Kb + 2*Gb));
Xf = ((Gf/8)*(9*Kf + 8*Gf)/(Kf + 2*Gf));

sBndry = 1/Kdry - 1/Kh;
sBn = (Gb*phic*sBndry*(Kb - Kf)*(4*Gf + 3*Kb))/(Kb*(3*Gb*Kb*phic - 3*Gb*Kf*phic - 3*Gf*Kb*phic + 3*Gf*Kf*phic + 4*Gb*Gf*Kb*sBndry + 3*Gb*Kb*Kf*sBndry - 4*Gb*Gf*Kb*phic*sBndry + 4*Gb*Gf*Kf*phic*sBndry));

sCtdry = 1/Gdry - 1/Gh - (4/15)*sBndry;
sCt = (Xb*phic*sCtdry*(Gb - Gf)*(4*Xf + 3*Gb))/(Gb*(3*Xb*Gb*phic - 3*Xb*Gf*phic - 3*Xf*Gb*phic + 3*Xf*Gf*phic + 4*Xb*Xf*Gb*sCtdry + 3*Xb*Gb*Gf*sCtdry - 4*Xb*Xf*Gb*phic*sCtdry + 4*Xb*Xf*Gf*phic*sCtdry));

Guf = 1/((4*sBn)/15 - (4*sBndry)/15 + sCt - sCtdry + 1/Gdry);
Kuf = 1/(sBn + 1/Kh);

Kzb = ((1-phin)*(1/Kb - 1/Kuf) + (3*phin/4)*(1/Gb - 1/Gf))/( (1/Kb)*(1/Kb - 1/Kuf) + (3*phin/4)*(1/(Kb*Gb) - 1/(Gf*Kuf)));
Ksat = (Kf*Kb^2 - Kf*Kb*Kzb + Kb^2*Kzb*phin - Kf*Kb*Kzb*phin)/(Kb^2*phin + Kf*Kb - Kf*Kzb - Kf*Kb*phin);

Gbc = (((1-phin)*(1/Gb - 1/Guf) + phin*(1/((Gb/6)*(9*Kb + 8*Gb)/(Kb + 2*Gb)) - 1/((Gf/6)*(9*Kf + 8*Gf)/(Kf + 2*Gf))))/((1/Gb)*(1/Gb - 1/Guf) + phin*(1/(Gb*((Gb/6)*(9*Kb + 8*Gb)/(Kb + 2*Gb))) - 1/(((Gf/6)*(9*Kf + 8*Gf)/(Kf + 2*Gf))*Guf))));
Gsat = (Gf*Gb^2 - Gf*Gb*Gbc + Gb^2*Gbc*phin - Gf*Gb*Gbc*phin)/(Gb^2*phin + Gf*Gb - Gf*Gbc - Gf*Gb*phin);


end

