function KS_inclusion_plots(s1,s2,k1,k2,g1,g2,imode)
% KS_inclusion_plots(s1,s2,k1,k2,g1,g2,imode)
% Uses SCA and DEM inclusion models on crossplots of bulk modulus and
% electrical conductivity
% Inputs
%    s1,s2      conductivities of solid and liquid phases
%    k1,k2      bulk moduli of solid and liquid phases
%    g1,g2      shear moduli of solid and liquid phases
%    imode      =0 for all plots
%               =1 for self-consistent only
%               =2 for DEM solid background
%               =3 for DEM liquid background
%               =4 for DEM both backgrounds

titstr ={['s1=',num2str(s1)]; 
    ['s2=',num2str(s2)]; 
    ['k1=',num2str(k1)]; 
    ['k2=',num2str(k2)]; 
    ['g1=',num2str(g1)];
    ['g2=',num2str(g2)]};
phi = [0:.01:.95];
defasp = {'[.01 .2 1 5 10]'};

answer = inputdlg({'aspect ratios'},'aspect ratios',1,defasp);
if isempty(answer), return; end;
asp = str2num(answer{1});

% asp = [1 .1  .01 .001];
% phic = 1;


if imode ==0 || imode==1,
    % Compute and plot self-consistent bulk modulus vs. self-consistent conductivity
    % one inclusion
    figure; hold on;
    for i=1:length(asp)
        for j=1:length(phi)
            [Condeff(j)]=cond_iso_inclusion_scmB([s1,s2],[1,asp(i)],[1-phi(j),phi(j)]);
            [ksc(j),gsc(j)]=berryscm([k1,k2],[g1,g2],[1,asp(i)],[1-phi(j),phi(j)]);
        end;
        scatterqq(Condeff/s2,ksc/k1,phi,[0 .4],jet);
%         scatterqq(Condeff/s2,ksc/k1,phi,[0 .4],jet);
        plot(Condeff/s2,ksc/k1,'-k');
        xt = interp1(ksc/k1,Condeff/s2,.5);
        text(1.5*xt,.5,num2str(asp(i)),'fontsize',14)
    end;
    box on; grid on; set(gca,'xscale','log');
    xlabel('S/Sfluid'); ylabel('K/Kfluid')
    title('Self Consistent; single inclusion');
    cbtitle('porosity')
    text(1e-3,.4,titstr);
    fsa20
    msa10
end;

% % % % Compute and plot self-consistent bulk modulus vs. self-consistent conductivity
% % % % Two inclusions
% % % figure; hold on;
% % % for i=1:length(asp)
% % %     for j=1:length(phi)
% % %         [Condeff(j)]=cond_iso_inclusion_scmB([s1,s2,s2],[1,1,asp(i)],[1-phi(j),(1-asp(i))*phi(j),asp(i)*phi(j)]);
% % %         [ksc(j),gsc(j)]=berryscm([k1,k2,k2],[g1,g2,g2],[1,1,asp(i)], [1-phi(j),(1-asp(i))*phi(j),asp(i)*phi(j)]);
% % %     end;
% % %     scatterqq(Condeff/s2,ksc/k1,phi,[0 .4],jet);
% % %     plot(Condeff/s2,ksc/k1,'-k');
% % %     xt = interp1(ksc/k1,Condeff/s2,.6);
% % %     text(1.5*xt,.5,num2str(asp(i)),'fontsize',14)
% % % end;
% % % box on; grid on; set(gca,'xscale','log');
% % % xlabel('S/Sfluid'); ylabel('K/Kfluid')
% % % title('Self Consistent; two inclusions');
% % % text(1e-3,.4,titstr);
% % % fsa20
% % % msa10

if imode == 0 || imode==2 || imode==4
    % Compute and plot dem bulk modulus vs. dem conductivity
    figure; hold on;
    for i=1:length(asp)
        % fluid inclusions phase2 ; background mineral phase 1
        [cdemA, porcA]=cond_iso_inclusion_dem(s1,s2,asp(i),1,1);
        [kdemA,~,poreA]=dem_gm(k1,g1,k2,g2,asp(i),1);
        cdemA = interp1(porcA,cdemA,phi);
        kdemA = interp1(poreA,kdemA,phi);
        h=scatterqq(cdemA/s2,kdemA/k1,phi,[0,.4],jet);
        h=plot(cdemA/s2,kdemA/k1,'-k');
        xt = interp1(kdemA/k1,cdemA/s2,.5);
        text(1.2*xt,.5,num2str(asp(i)),'fontsize',14)
    end;
    hline = findobj(gca,'type','line');
    set(hline,'marker','sq','markeredgecolor',[.8 .8 .8]);
    for k=1:length(hline),set(hline(k),'marker','sq','markeredgecolor',get(hline(k),'markerfacecolor')); end
    box on; grid on; set(gca,'xscale','log');
    xlabel('S/Sfluid'); ylabel('K/Kmin')
    title('DEM; solid background')
    cbtitle('porosity')
    text(1e-3,.4,titstr);
    fsa20
    msa8
end;

if imode == 0 || imode== 3 || imode == 4
    figure; hold on;
    for i=1:length(asp)
    %     solid inclusions phase 1; background fluid phase 2
        [cdemB, porcB]=cond_iso_inclusion_dem(s2,s1,asp(i),1,1);
        [kdemB,~,poreB]=dem_gm(k2,g2,k1,g1,asp(i),1);
        cdemB = interp1(porcB,cdemB,phi);
        kdemB = interp1(poreB,kdemB,phi);
        scatterqq(cdemB/s2,kdemB/k1,1-phi,[0,.4],jet);
        plot(cdemB/s2,kdemB/k1,'-k');
        xt = interp1(kdemB/k1,cdemB/s2,.5);
        text(1.2*xt,.5,num2str(asp(i)),'fontsize',14)
    end;
%     set(findobj(gca,'type','line'),'marker','^');
    hline = findobj(gca,'type','line');
    set(hline,'marker','^');
    for k=1:length(hline), set(hline(k),'markeredgecolor',get(hline(k),'markerfacecolor')); end
    box on; grid on; set(gca,'xscale','log');
    xlabel('S/Sfluid'); ylabel('K/Kmin')
    title('DEM; liquid background')
    cbtitle('porosity')
    text(1e-3,.4,titstr);
    fsa20
    msa8
end;

