function KS_GT_mtrends(s1, s2, k1, k2, g1, g2, phic, colmap)
% Computes (conductivity-porosity) S-Phi pairs for several Archie's law trends (several m-values)
% Then for each (S-Phi) pair, the G&T bounds on bulk modulus K are
% computed.

%     kmin   = 36;
%     gmin   = 44;
%     kfl    = 2.5;
%     gfl    = 0;
%     s1     = 0.000;
%     s2     = 1;
%     phic   = 0.4;
m      = [1.5 2 3 ];
colr   = {'r','b','g','y','m'};

colrlim = [0 phic];

% vector of porosities to model
phi = [.00: .01 :1]';
% HS upper and lower bounds on conductivity
[sHS1,sHS2] = HSaverageCondB(1-phi,s1,s2);
% normalized:
sHS1=sHS1/s2; sHS2=sHS2/s2;
selenv=radiodlg({'select envelope to plot'},...
                 {'K1-K2','K2-K3','K1-K3','K3+/-.4'});
sel   =radiodlg({'select GT lines to highlight'},{'GT1','GT2','GT3'});
% make envelopes of S-K
figure; hold on;
for j=1:length(m)
   S = phi.^m(j);  S=S(:);
   S(S<sHS1) = sHS1(S<sHS1);
   S(S>sHS2) = sHS2(S>sHS2);
   [K1,K2,K3,K4,K5] = GT(1-phi,phi, s1, s2, k1, k2, g1, g2, S);
   splot = [S(:);flipud(S(:))];
   if selenv==1,
       kplot = [K1(:)/k1; flipud(K2(:)/k1)];
   elseif selenv==2,
       kplot = [K2(:)/k1; flipud(K3(:)/k1)];
   elseif selenv==3,
       kplot = [K1(:)/k1; flipud(K3(:)/k1)];
   elseif selenv==4,
      kplot = [    (0.3*K2 + 0.7*K3)/k1; flipud((0.3*K1 + 0.7*K3)/k1)];
   end;
   indplot = (isnan(splot) | isnan(kplot));
   splot(indplot)=[];
   kplot(indplot) = [];
   fill(splot,kplot,colr{j},'facealpha',0.2); 
   text(S(20),K2(20)/k1,num2str(m(j)),'fontsize',14);
   text(S(20),K3(20)/k1,num2str(m(j)),'fontsize',14);
   xlabel('S/Sfluid');ylabel('K/Kmin'); title('G&T envelopes of K, for different Archie S-Phi trends');
   if sel == 1,
       h1=scatterqq(S,K1/k1,phi,colrlim,jet);
   elseif sel == 2,
       h1=scatterqq(S,K2/k1,phi,colrlim,jet);
   elseif sel == 3,
       h2=scatterqq(S,K3/k1,phi,colrlim,jet);
   end;
%        text(S(50),K2(50)/k1,num2str(m(j)),'fontsize',12);
%        text(S(50),K3(50)/k1,num2str(m(j)),'fontsize',12);
   box on; grid on; msa6
   set(gca,'xscale','log'); xlim([1e-3 1])
   cbtitle('porosity');

end;
fsa16
        
figure; hold on;
for j=1:length(m)
   S = phi.^m(j);  S=S(:);
   S(S<sHS1) = nan;
   S(S>sHS2) = nan;
   [K1,K2,K3,K4,K5] = GT(1-phi,phi, s1, s2, k1, k2, g1, g2, S);
   h1=scatterqq(S,K2/k1,phi,[0 1],jet);
   h2=scatterqq(S,K3/k1,phi,[0 1],jet);
   text(S(50),K2(50)/k1,num2str(m(j)));
   text(S(50),K3(50)/k1,num2str(m(j)));
   xlabel('S/Sfluid'); ylabel('K/Kmin'); title('G-T bounds for different Archie S-Phi trends');
   cbtitle('porosity');
end;
fsa14    

% % %     figure; hold on;
% % %     for j=1:length(m)
% % %        S = phi.^m(j);  S=S(:);
% % %        S(S<sHS1) = sHS1(S<sHS1);
% % %        S(S>sHS2) = sHS2(S>sHS2);
% % %        [K1,K2,K3,K4,K5] = GT(1-phi,phi, s1, s2, k1, k2, g1, g2, S);
% % %        h1=plot3(S,K2/k1,phi);
% % %        h2=plot3(S,K3/k1,phi);
% % %        text(S(50),K2(50)/k1,num2str(m(j)));
% % %        text(S(50),K3(50)/k1,num2str(m(j)));
% % %        xlabel('S'); ylabel('K'); title('G-T bounds for different m-values');
% % %        cbtitle('porosity');
% % %     end;
% % %     fsa14    
    
% % % figure; hold on;
% % % for j=1:length(m)
% % %    S = phi.^m(j);  S=S(:);
% % %    S(S<sHS1) = sHS1(S<sHS1);
% % %    S(S>sHS2) = sHS2(S>sHS2);
% % %    [K1,K2,K3,K4,K5] = GT(1-phi,phi, s1, s2, k1, k2, g1, g2, S);
% % %    splot = [S(:);flipud(S(:))];
% % %    kplot = [K2(:)/k1; flipud(K3(:)/k1)];
% % %    phiplot = [phi(:); flipud(phi(:))];
% % % 
% % %    indplot = (isnan(splot) | isnan(kplot) | isnan(phiplot));
% % %    splot(indplot)   = [];
% % %    kplot(indplot)   = [];
% % %    phiplot(indplot) = [];
% % % 
% % % 
% % %    fill3(splot,kplot,phiplot,colr{j},'facealpha',0.2);
% % %    box on;
% % % %        text(splot(50),kplot(50),num2str(m(j)),'fontsize',12);
% % % %        text(S(50),K3(50)/k1,num2str(m(j)),'fontsize',12);
% % % 
% % %    xlabel('S/Sfluid');ylabel('K/Kfluid');zlabel('phi');
% % % %        fill3([S;flipud(S)],[K2/k1; flipud(K3)/k1],[phi;flipud(phi)],colr{j},'facealpha',0.2); xlabel('S');ylabel('K');
% % % end;
% % % fsa14
    
% % % figure; hold on;
% % % for j=1:length(m)
% % %    S = phi.^m(j);  S=S(:);
% % %    S(S<sHS1) = nan;
% % %    S(S>sHS2) = nan;
% % %    [K1,K2,K3,K4,K5] = GT(1-phi,phi, s1, s2, k1, k2, g1, g2, S);
% % %    plot(phi,K2/k1,colr{j}); 
% % %    plot(phi,K3/k1,colr{j}); 
% % %    xlabel('phi');ylabel('K');
% % % end;
% % % [kHS1,kHS2] = HSaverageB(1-phi,k1,k2,g1,0);
% % % plot(phi,kHS1/k1,phi,kHS2/k1)
% % % fsa14
% % % 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function [FF1,FF2,FF3,FF4,FF5]=GT(f1, f2, s1, s2, k1, k2, g1, g2, sdata)

a1 = 6.*(g1-g2).*((f1.*s2+f2.*s1+2*s2).^2).*((k1-k2).^2)./( ((s1-s2).^3).*((3*f1.*k2+3*f2.*k1+4*g2).^2) );
a2 = a1.*3*s1.*(3*k1+4*g2)./((s1+2*s2).*(3*k1+4*g1));
a3 = a1.*(2*s1+s2).*(3*k2+4*g2)./(3*s2.*(3*k2+4*g1));
a4 = a1.*2*s1.*g2./((s1+s2).*g1);
a5 = a1.*(s1+s2).*g2./(2.*s2.*g1);
FF1 = makeFF(a1,s1,s2,k1,k2,g1,g2,f1,sdata);
FF2 = makeFF(a2,s1,s2,k1,k2,g1,g2,f1,sdata);
FF3 = makeFF(a3,s1,s2,k1,k2,g1,g2,f1,sdata);
FF4 = makeFF(a4,s1,s2,k1,k2,g1,g2,f1,sdata);
FF5 = makeFF(a5,s1,s2,k1,k2,g1,g2,f1,sdata);
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
function FF = makeFF(a,s1,s2,k1,k2,g1,g2,f1,s)

[kHS1,kHS2] = HSaverageB(f1,k1,k2,g1,g2);
[sHS1,sHS2] = HSaverageCondB(f1,s1,s2);
FF = (a.*kHS1.*(sHS2-s).*(sHS1-sHS2) - kHS2.*(sHS1-s).*(kHS1-kHS2) )./ (a.*(sHS2-s).*(sHS1-sHS2) - (sHS1-s).*(kHS1-kHS2) );
