function [sHS1,sHS2]=HSaverageCondB(f1,s1,s2)
% [sHS1,sHS2]=HSaverageB(f1,k1,k2)
%
% Calculate the HS "Averages" for a bimodal aggregate.
% Calculation is the same as the HS bounds, but here we don't distinguish
% the UPPER and LOWER -- only whether it is weighted by material 1 or
% material 2.
% 
% This version allows vector inputs, as in well logs, so there are only two
% constituents
%
% input:   
%           f1       - fraction of first constituent.  Can be a vector
%           s1,s2  - conductivities of constituents
% output:  
%           sHS1, sHS2  - Hashin-Shtrikman averages, weighted by end member constituent 1
%
% See also boundvectB, in which the stiffest input moduli are detected, so
% that outputs can be designated as upper and lower bounds.

% Gary Mavko 

f1 = f1(:);s1=s1(:);s2=s2(:);
f2 = 1-f1;

c=2;

% compute averages for effective conductivity
sHS1 = 1./(f1./(s1+c*s1) + f2./(s2+c*s1))-c*s1;
sHS2 = 1./(f1./(s1+c*s2) + f2./(s2+c*s2))-c*s2;	


sHS1(isnan(f1))   =nan;
kHS2(isnan(f1))   =nan;
sHS1(f1<0 | f1>1) =nan;
sHS2(f1<0 | f1>1) =nan;

