function [kHS1,kHS2,gHS1,gHS2]=HSaverageB(f1,k1,k2,g1,g2)
% [kHS1,kHS2,gHS1,gHS2]=HSaverageB(f1,k1,k2,g1,g2)
%
% Calculate the HS "Averages" for a bimodal aggregate.
% Calculation is the same as the HS bounds, but here we don't distinguish
% the UPPER and LOWER -- only whether it is weighted by material 1 or
% material 2.
% 
% This version allows vector inputs, as in well logs, so there are only two
% constituents
%
% input:   
%           f1       - fraction of first constituent.  Can be a vector
%           k1,k2  - bulk moduli of constituents
%           g1,g2  - shear moduli of constituents
% output:  
%           kHS1, gHS1  - Hashin-Shtrikman averages, weighted by end member constituent 1
%           kHS2, gHS2  - Hashin-Shtrikman averages, weighted by end member constituent 2
%
% See also boundvectB, in which the stiffest input moduli are detected, so
% that outputs can be designated as upper and lower bounds.

% Gary Mavko 

f1 = f1(:);k1=k1(:);k2=k2(:);g1=g1(:);g2=g2(:);
f2 = 1-f1;

c=4/3;

% compute averages for effective bulk modulus
kHS1 = 1./(f1./(k1+c*g1) + f2./(k2+c*g1))-c*g1;
kHS2 = 1./(f1./(k1+c*g2) + f2./(k2+c*g2))-c*g2;	

eta1 = g1.*(9*k1+8*g1)./(k1+2*g1)/6;
eta2 = g2.*(9*k2+8*g2)./(k2+2*g2)/6;

% compute averages for effective shear modulus
gHS1 = (g1+eta1).*(g2+eta1)./(f1.*(g2+eta1) + f2.*(g1+eta1) + eps) - eta1;
gHS2 = (g1+eta2).*(g2+eta2)./(f1.*(g2+eta2) + f2.*(g1+eta2) + eps) - eta2;

kHS1(isnan(f1))  =nan;
kHS2(isnan(f1))   =nan;
gHS1(isnan(f1))  =nan;
gHS2(isnan(f1))   =nan;

kHS1(f1<0 | f1>1) =nan;
kHS2(f1<0 | f1>1)  =nan;
gHS1(f1<0 | f1>1) =nan;
gHS2(f1<0 | f1>1)  =nan;

