function [Ksatb1,Ksatb2,KsatHS1,KsatHS2] = FluidSubMultiMineral(Ksat1,Kf1,Kf2,phi,Kq,Gq,phiq)
%[Ksatb1,Ksatb2,KsatHS1,KsatHS2] = FluidSubMultiMineral(Ksat1,Gsat1,Kf1,phi1,Kq,Gq,phiq,Kf2)
%
% Approximate bounds on fluid substitution in multimineralic rocks with
% interconnected pores

% Inputs
% Ksat1: original bulk modulus of rock saturated with fluid of bulk modulus KFL1
% Kf1: initial fluid modulus
% Kf2: final fluid modulus
% phi: rock porosity (fluid volume fraction)
% Kq: Vector with mineral bulk moduli, example Kq = [36 46 56 ...]
% Gq: Vector with mineral shear moduli, example Gq = [45 48 30 ...]
% phiq: Vector with mineral volume fractions, example phiq = [0.2 0.3 0.1
% Note that sum(phiq) = 1 - phi

% Outputs
% Ksatb1: Iso-strain approximation
% Ksatb1: Iso-stress approximation
% KsatHS1: HS+ approximation
% KsatHS2: HS- approximation

% Fluid substitution guess = (KsatHS1 + KsatHS2)/2  or (Ksatb1 + Ksatb2)/2

%Written by Nishank Saxena

phi1 = phi;
Gf1=1e-9; Gf2=1e-9;
[Kb,I] = max(Kq);

delta1 = 1/sum((phiq./phi1).*(1./Kq - 1/Kb));
delta2 = 1/sum((phiq./phi1).*(1./Kq - 1/Kb));
phi = phi1;
Ksatb1 = -(((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)) - 1)/(1/Ksat1 - ((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(Kb*phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)));

delta1 = 1/sum(((phiq.*Kq)./(phi1*Kf1)).*(1./Kq - 1/Kb));
delta2 = 1/sum(((phiq.*Kq)./(phi1*Kf2)).*(1./Kq - 1/Kb));
Ksatb2 = -(((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)) - 1)/(1/Ksat1 - ((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(Kb*phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)));


% Ksatmean = (Ksatb1 + Ksatb2)/2;

for i = 1:length(phiq)
[KHSp,KHSm,GHSp,GHSm]=bound(1,[phiq(i)/(phiq(i) + phi1) phi1/(phiq(i) + phi1)],[Kq(i) Kf1],[Gq(i) Gf1]);
xgh1(i) = Kq(i)*(KHSp - Kf1)/(Kf1*(Kq(i) - KHSp));
lgh1(i) = Kq(i)*(KHSm - Kf1)/(Kf1*(Kq(i) - KHSm));
xoh1(i) = Gq(i)*(GHSp - Gf1)/(Gf1*(Gq(i) - GHSp));
loh1(i) = Gq(i)*(GHSm - Gf1)/(Gf1*(Gq(i) - GHSm));

[KHSp,KHSm,GHSp,GHSm]=bound(1,[phiq(i)/(phiq(i) + phi1) phi1/(phiq(i) + phi1)],[Kq(i) Kf2],[Gq(i) Gf2]);
xgh2(i) = Kq(i)*(KHSp - Kf2)/(Kf2*(Kq(i) - KHSp));
lgh2(i) = Kq(i)*(KHSm - Kf2)/(Kf2*(Kq(i) - KHSm));
xoh2(i) = Gq(i)*(GHSp - Gf2)/(Gf2*(Gq(i) - GHSp));
loh2(i) = Gq(i)*(GHSm - Gf2)/(Gf2*(Gq(i) - GHSm));

end

delta1 = 1/sum(xgh1.*(1./Kq - 1/Kb));
delta2 = 1/sum(xgh2.*(1./Kq - 1/Kb));
phi = phi1;
KsatHS1 = -(((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)) - 1)/(1/Ksat1 - ((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(Kb*phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)));

delta1 = 1/sum(lgh1.*(1./Kq - 1/Kb));
delta2 = 1/sum(lgh2.*(1./Kq - 1/Kb));
phi = phi1;
KsatHS2 = -(((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)) - 1)/(1/Ksat1 - ((1/Kf1 - 1/Kf2)*(1/Kb - 1/Ksat1))/(Kb*phi*(1/Kf1 - 1/Kb + 1/delta1)*(1/Kf2 - 1/Kb + 1/delta2)));



end

