function [Kmin, Kmax] = Embbound_bulk_Dub(Kb1,Gb1,Kb2,Gb2,Ka1,Ga1,Ka2,Ga2,Phi,Ksat)
% [Kmin, Kmax] = Embbound_bulk_Dub(Kb1,Gb1,Kb2,Gb2,Ka1,Ga1,Ka2,Ga2,Phi,Ksat)
% Solid substitution range predicted by the Embedded Bound Method for Rock Bulk Modulus (Unconstrained)
% Method allows you to replace both "mineral" and "pore"

% Inputs:
%    Kb1,Gb1              initial moduli of the "mineral" material
%    Kb2,Gb2              final moduli of the "mineral" material
%    Ka1,Ga1              intial moduli of the pore-fill moduli 
%    Ka2,Ga2              final moduli of the pore-fill moduli 
%    Phi,Ksat            Porosity and initial rock bulk modulus measurement

% Outputs
% Kmin and Kmax: Smallest and largest possible new solid-filled rock "bulk" modulus 

% Written by Nishank Saxena

% see also Embbound_shear_Dub

K1 = Kb1; G1 = Gb1; K2 = Ka1; G2 = Ga1; K3 = Ka2; G3 = Ga2; Mx = Ksat; nx = Phi;
K11 = Kb2; G11 = Gb2;

Kp = K1;
Gp = G1;
fqq = 1:-1e-6:(nx-1e-6);
nqq = nx./fqq;
Kq = K2 + (1-nqq)./(1/(K1 - K2) + nqq./(K2 + (4/3)*G2));
Gq = G2 + (1-nqq)./(1/(G1 - G2) + 2*nqq*(K2 + 2*G2)/(5*G2*(K2 + (4/3)*G2)));
Mxx = (Kp + fqq./(1./(Kq - Kp) + (1-fqq)./(Kp + (4/3)*Gp))) ;
Test = abs(Mx - Mxx);
nq = nqq(Test == min(Test));
fq = fqq(Test == min(Test));
a = Test(Test == min(Test));
clearvars -except K1 G1 K2 G2 K3 G3 Mx nx nq fq K11 G11;

Kp = K11;
Gp = G11;
Kq = K3 + (1-nq)/(1/(K11 - K3) + nq/(K3 + (4/3)*G3));
Gq = G3 + (1-nq)/(1/(G11 - G3) + 2*nq*(K3 + 2*G3)/(5*G3*(K3 + (4/3)*G3)));
Mxout_HSpmin = (Kp + fq./(1/(Kq - Kp) + (1-fq)./(Kp + (4/3)*Gp))) ;
clearvars -except K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin K11 G11;

% new mod
Kq = K2;
Gq = G2;
fqq = 0:1e-6:1;
npp = (nx - fqq)./(1-fqq);
Kp = K1 + npp./(1/(K2 - K1) + (1-npp)./(K1 + (4/3)*G1));
Gp = G1 + npp./(1/(G2 - G1) + 2*(1-npp).*(K1 + 2*G1)./(5*G1*(K1 + (4/3)*G1)));
Mxx = Kq + (1-fqq)./(1./(Kp - Kq) + fqq./(Kq + (4/3)*Gq)) ;
Test = abs(Mx - Mxx);
np = npp(Test == min(Test));
fq = fqq(Test == min(Test));
Kptest = Kp(Test == min(Test));
Gptest = Gp(Test == min(Test));
Mxtest = Mxx(Test == min(Test));
a = Test(Test == min(Test));
clearvars -except K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin fq np K11 G11;

Kq = K3;
Gq = G3;
Kp = K11 + np./(1/(K3 - K11) + (1-np)./(K11 + (4/3)*G11));
Gp = G11 + np./(1/(G3 - G11) + 2*(1-np).*(K11 + 2*G11)./(5*G11*(K11 + (4/3)*G11)));
Mxout_HSmf = Kq + (1-fq)./(1./(Kp - Kq) + fq./(Kq + (4/3)*Gq)) ;

clearvars -except  K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin Mxout_HSmf K11 G11;

% new mod
fqq = 1:-1e-6:(nx-1e-6);
nqq = nx./fqq;
Kq = K1 + (nqq)./(1/(K2 - K1) + (1-nqq)./(K1 + (4/3)*G1));
Gq = G1 + (nqq)./(1/(G2 - G1) + 2*(1-nqq).*(K1 + 2*G1)/(5*G1*(K1 + (4/3)*G1)));
Mxx = (Kq + (1-fqq)./(1./(K1 - Kq) + (fqq)./(Kq + (4/3)*Gq))) ;
Test = abs(Mx - Mxx);
nq = nqq(Test == min(Test));
fq = fqq(Test == min(Test));
a = Test(Test == min(Test));
clearvars -except  K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin Mxout_HSmf nq fq K11 G11;

Kq = K11 + (nq)./(1/(K3 - K11) + (1-nq)./(K11 + (4/3)*G11));
Gq = G11 + (nq)./(1/(G3 - G11) + 2*(1-nq).*(K11 + 2*G11)/(5*G11*(K11 + (4/3)*G11)));
Mxout_HSmmin = (Kq + (1-fq)./(1./(K11 - Kq) + (fq)./(Kq + (4/3)*Gq))) ;
clearvars -except  K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin Mxout_HSmf Mxout_HSmmin K11 G11;

% new mod
fqq = 0:1e-6:1;
nqq = (nx - (1-fqq))./fqq;
% plot(fqq,nqq);
Kq = K2 + (1-nqq)./(1/(K1 - K2) + (nqq)./(K2 + (4/3)*G2));
Gq = G2 + (1-nqq)./(1/(G1 - G2) + 2*(nqq).*(K2 + 2*G2)/(5*G2*(K2 + (4/3)*G2)));
Mxx1 = (Kq + (1-fqq)./(1./(K2 - Kq) + (fqq)./(Kq + (4/3)*Gq)));
Test = abs(Mx - Mxx1);
% plot(nqq,Test);
nq = nqq(Test == min(Test));
fq = fqq(Test == min(Test));
a = Test(Test == min(Test));
clearvars -except  K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin Mxout_HSmf Mxout_HSmmin nq fq Mxx1 K11 G11;

Kq = K3 + (1-nq)./(1/(K11 - K3) + (nq)./(K3 + (4/3)*G3));
Gq = G3 + (1-nq)./(1/(G11 - G3) + 2*(nq).*(K3 + 2*G3)/(5*G3*(K3 + (4/3)*G3)));
Mxout_HSpf = (Kq + (1-fq)./(1./(K3 - Kq) + (fq)./(Kq + (4/3)*Gq))) ;
clearvars -except  K1 G1 K2 G2 K3 G3 Mx nx Mxout_HSpmin Mxout_HSmf Mxout_HSmmin Mxout_HSpf Mxx1 K11 G11;

Mans=[Mxout_HSpmin Mxout_HSmmin Mxout_HSpf Mxout_HSmf]
Kmin = min(Mans);
Kmax = max(Mans);
end

