% RPHIIItools.   Matlab functions in the supplementary web site for the
% Rock Physics Handbook, 3rd Edition, by Mavko, Mukerji, and Dvorkin, 2020
%  
% AVO
% avo_abe                            	- Shuey's AVO approximation for AVO.
% avopp                              	- P-to-P AVO; single interface; Zoeppritz & approximations. 
% avops                              	- P-to-S AVO;  single interface; Zoeppritz & approximations. 
% Rorsym 	                            - Calculates the reflectivity in the symmetry plane for interfaces between orthorhombic media
% Rruger 	                            - Reflectivity AVOZ in weakly anisotropic media
% Rvavrycuk 	                        - Calculates P-P reflectivity at interface between two materials with weak arbitrary anisotropy
% 
% CROSS RELATIONS and SOLID SUBSTITUTION
% Cond_crossbound_manager               - wrapper to call programs for cross bounds of electrical conductivity and bulk modulus
% Embbound_bulk                	        - Solid substitution for bulk modulus. 
% Embbound_bulk_Dub          	        - Solid substitution for bulk modulus, where both phases can change. 
% Embbound_shear               	        - Solid substitution for shear modulus. 
% Embbound_shear_Dub       	            - Solid substitution for shear modulus, where both phases can change.
% gibiansky_torquato_crossbounds        - Gibiansky-Torquato electrical-elasticity cross bounds 
% KS_GT_mtrends                 	    - Computes Gibiansky-Torquato conductivity-elasticity cross bounds.
% KS_inclusion_plotsB         	        - Superimposes DEM and SCA inclusion models onto the Gibiansky-Torquato electrical-elasticity cross bounds
% Solidsquirt                    	    - Solid substitution equivalent of the squirt model
% Solidsquirt_uf                 	    - Solid substitution equivalent of the squirt model, unrelaxed frame
% Solidsub                              - Solid substitution lower bound - generalized Gassmann
% Pwavesub                       	    - Solid substitution of P-wave modulus, without knowledge of shear modulus.
% runGandT                       	    - Computes Gibiansky-Torquato elastic-electrical cross bounds.  
% runGandT4                      	    - Computes Gibiansky-Torquato elastic-electrical cross bounds bounds.  
% 
% EFFECTIVE MEDIUM, ELASTIC
% berrysc                            	- Effective elastic moduli using Berryman's Self-Consistent approximation
% berryscm                           	- Effective elastic moduli for multi-component (n>2) composite using Berryman's Self-Consistent
% berryscp                           	- Effective elastic moduli vs. pressure for multi-component media using Berryman's Self-Consistent
% bkus                               	- Backus average for thin layered TI anisotropy
% bkusc                              	- Backus average for thin layered TI anisotropy
% bkuslog                           	- Backus average of segment of well log
% bound                              	- Voigt-Reuss & Hashin-Shtrikman elastic bounds
% bounds                            	- Voigt-Reuss & Hashin-Shtrikman elastic bounds
% c2anis                             	- Compute Thomsen parameters from VTI Voigt notation matrix
% c2sti                              	- Converts VTI elastic stiffnesses to elastic compliances
% c2vti                              	- Computes Vp, Vsh, and Vsv at any direction in a VTI material
% CSiso                              	- Creates Voigt notation compliance and stiffness matrices for isotropic material
% cti2v                              	- Computes Vp and Vs in the fast and slow directions of VTI material
% Cem                                	- Computes modulus-porosity trends from Dvorkin's contact cement model
% dem                                	- Effective elastic moduli using Differential Effective Medium approximation
% critpor                            	- Velocities, density, and moduli at critical porosity
% dem1                              	- Effective elastic moduli using Differential Effective Medium model
% dem_anisoC                            - Anisotropic Differential Effective Medium, with aligned spheroidal inclusions
% dem_gm                             	- DEM - Effective elastic moduli using Differential Effective Medium
% demyprime                          	- f\Function called by the DEM programs
% echeng                             	- Eshelby-Cheng VTI model for aligned spheroidal inclusions
% hash                               	- Hashin-Shtrikman upper and lower bound effective moduli
% hashv                              	- Hashin-Shtrikman upper and lower bound velocities
% hertzmind                          	- Computes bulk and shear moduli of a dry elastic sphere pack using Hertz-Mindlin
% hertzmindv                         	- Computes P- and S-wave velocities of dry elastic sphere pack using Hertz-Mindlin
% hudson                             	- Computes effective elastic moduli of rock with single set of aligned cracks, Hudson model
% hudson1                            	- Computes effective elastic moduli of rock with single set of aligned cracks, Hudson model
% hudson3                            	- Computes effective elastic moduli of rock with three perpendicular sets of cracks, Hudson model
% hudsoncone                    	    - Computes effective elastic moduli with crack normals randomly distributed at fixed angle of symmetry.
% hudsonF                           	- Computes effective elastic moduli with crack normals oriented with Fisher distribution
% HSaverageB                            - Hashin-Shtrikman elastic bounds
% John_Makse	                        - Effective elastic moduli with uniaxial strain of a random sphere pack. Makse correction to Norris-Johnson
% Johnson                           	- Effective elastic moduli with uniaxial strain of a random sphere pack. Norris-Johnson model
% ku2v                               	- Isotropic elastic velocities from input elastic constants
% lm2v                              	- Isotropic elastic velocities from input elastic constants
% moritanaka                         	- Mori-Tanaka method for effective elastic moduli for multi-component composite 
% sca_aniso                          	- Self-consistent approximation for moduli with a single set of aligned ellipsoidal inclusions
% Unconsol                         	    - Soft sand model - modified lower Hashin-Shtrikman curve with Hertz-Mindlin end points
% v2cti                              	- VTI Elastic stiffness from velocities at angles 0, 45, and 90 degrees from the symmetry axis
% v2ku                              	- Isotropic moduli computed from Vp, Vs, and density
% v2lm                              	- Isotropic moduli computed from Vp, Vs, and density
% walton                             	- Buik and shear moduli of a sphere pack using Walton's model
% waltonv                            	- Velocities in a sphere pack using Walton's model
% 
% EFFECTIVE MEDIUM, ELECTRICAL
% cond_aligned_inclusion_dem   	        - VTI electric conductivity resulting from single set of aligned cracks; DEM approximation
% cond_aligned_inclusion_scm   	        - VTI electric conductivity resulting from single set of aligned cracks; SCA approximation
% cond_Bruggeman_polarized    	        - Bruggeman conductivity model, random inclusions
% cond_iso_inclusion_CM             	- Effective dielectric constant using Clausius Mosotti approximation
% cond_iso_inclusion_dem                - Effective electrical conductivity using differential effective medium model of spheroidal inclusions
% cond_iso_inclusion_scmB               - Effective electrical conductivity using the self-consistent approximation of spheroidal inclusions
% cond_iso_shells_scm                	- Effective electrical conductivity for concentric spherical shells
% demyprime_cond_Bruggeman_polarized    - program called by cond_Bruggeman_polarized    
% demyprimeN_cond_aligned     	        - program called by DEM model for aligned ellipsoidal inclusions
% demyprimeN_cond_iso                   - program called by DEM model for randomly oriented inclusions
% Rfactor_cond_iso                   	- Computes the electric field concentration tensor, R, for a spheroidal inclusion
% HSaverageCondB                     	- Hashin-Shtrikman bound on effective electrical conductivity
% 
% FLUID PROPERTIES AND FLUID SUBSTITUTION
% BKc2c                              	- Brown-Korringa fluid substitution in terms of Voigt notation stiffnesses
% BKd2s                             	- Brown-Korringa dry to saturated fluid substitution in terms of Voigt notation compliances
% BKs2d                              	- Brown-Korringa saturated to dry fluid substitution in terms of Voigt notation compliances
% BKs2s                              	- Brown-Korringa fluid substitution in terms of Voigt notation compliances
% bkti                               	- Brown-Korringa fluid substitution
% co2prop                            	- CO2 properties vs. Temperature and Pressure
% gassmnk                            	- Gassmann fluid substitution of elastic bulk modulus
% gassmnv	                            - Gassmann fluid substitution expressed as velocities
% flprop                             	- Batzle-Wang relations for reservoir fluid properties
% flpropui 	                            - GUI to calculate Batzle-Wang relations for reservoir fluid properties
% FluidSubMultiMineral         	        - Gassmann fluid substitution with average of multiple minerals
% mmti                               	- Wet unrelaxed frame of VTI rock using squirt model
% 
% PERMEABILITY
% BernabeE                           	- Predicts permeability and porosity in rock with pressure-dependent pores and cracks
% Bloch                              	- Predicts permeability and porosity in sandstone. 
% CoatDum                            	- Coates-Dumanoir equation for permeability from porosity and irreducible water saturation
% Coates                             	- Equation for predicting permeability from porosity and irreducible water saturation
% FredrichE                          	- Predicts permeability from porosity and formation factor
% KozCarmE                           	- Original Kozeny-Carman relation for permeability
% ModKozCarm                   	        - Generalization of Kozeny-Carman in terms of pore diameter, geometric factor, porosity, and percolation porosity
% Owolabi                            	- Predicts permeability in unconsolidated sands of Eastern Niger delta 
% PandaLake                          	- Predicts permeability in terms of tortuosity and particle size distribution extending Kozeny-Carman 
% PandaLakeKCE                 	        - Predicts the effect of cement on permeability 
% PermMenu                           	- Wrapper to call other permeability predictors
% Timur                              	- Predicts permeability from porosity and irreducible water saturation 
% Tixier                             	- Empirical prediction of permeability in unconsolidated sands of Eastern Niger delta
% WylGregE                           	- Predicts permeability from porosity and specific surface area 
% 
% SYNTHETIC SEISMIC TRACES
% eimp                               	- Predicts elastic far-offset elastic impedances for P-to-P and P-to-S
% eimp2                              	- Predicts elastic far-offset elastic impedances for P-to-P and P-to-S
% ezseis                             	- Quick approximate synthetic seismic traces from low-pass filtering of reflectivity sequence
% iatrib                             	- Estimates instantaneous seismic attributes from an image
% kenfdisp                           	- Kennet-Frazer algorithm to predict velocity vs. Frequency in normal-incidence layered earth
% kenfrtt                            	- Kennet-Frazer algorithm to predict normal incidence travel time in layered earth
% kennet                             	- Synthetic seismograms for plane wave, normal incidence propagation
% kennett_aux                        	- Synthetic seismograms for plane wave, normal incidence propagation
% rtcdppp                            	- Synthetic ray-trace P-to-P seismic section in a 1D layered earth model
% rtcdpppQ                           	- Synthetic ray-trace P-to-P seismic section with Q in a 1D layered earth model
% rtcdpps                            	- Synthetic ray-trace P-to-S seismic section in a 1D layered earth model
% rtcdppsQ                           	- Synthetic ray-trace P-to-S seismic section with Q in a 1D layered earth model
% rtppaniso                          	- Synthetic ray-trace P-to-P seismic section in a 1D layered earth model with VTI layers
% sourcewvlt                         	- Generates Claerbout's minimum phase wavelet
% sourcewvlt_gary                       - Generates Claerbout's minimum phase wavelet
% pgator                            	- Propagator matrix method for synthetic seismograms for plane wave, normal incidence propagation
% 
% UTILITIES
% bayesclass                         	- Bayes classification based on pdf
% blockav                            	- Block average of logs or signals
% cbtitle                            	- puts a title on a colorbar, analogous to title.m
% ezbond                             	- coordinate transformation of elastic matrix in Voigt notation
% fftplot                            	- plot amplitude and phase spectrum of time series.
% fillnan                            	- replaces NANs in a vector using a variety of interpolators
% find_dependencies           	        - Generates a dependency report for a single function
% ft1axis                            	- Fourier Transform in time axis(column-wise).
% ft2axis                            	- Fourier Transform in space axis(row-wise).
% hist2d                             	- 2 Dimensional Histogram.
% hist3d                             	- 3 Dimensional Histogram.
% interpnext                         	- a form of interpolation that chooses the next existing value rather than an average of multiple values
% loadlas                            	- Reads well-log .las file and puts curves into a Matlab structure
% monte                              	- Monte-Carlo draws from non-parametric marginal cdf followed by linear regression
% monteccdf                          	- Monte-Carlo draws from non-parametric conditional cdfs
% outputdlg                          	- folder of calls for quick change of markersize and fontsize in an existing plot
% pdfbayes	                            - Non-parametric pdf estimation, Bayes' error & Information
% radiodlg                           	- created a dialog box with radio buttons, somewhat analogous to inputdlg.m
% scatterqq                          	- alternative to scatter plot 
% shortcuts folder	                    - folder of calls for quick change of markersize and fontsize in an existing plot
% 
% VISCOELASTICITY AND DISPERSION
% biot                               	- Velocity dispersion and attenuation from Biot theory
% biothf                             	- High frequency limiting velocity from Biot theory 
% biothfb                            	- Approximate high frequency limiting velocity from Biot theory
% patchw                            	- White's patchy model with Dutta-Ode correction
% squirt	                            - Mavko squirt model for high frequency saturated velocities
% stdlin                             	- Standard linear viscoelastic solid
% viscoelastic                       	- Creates dispersion curves for common viscoelastic models
% 
% 


