function Cond_crossbound_manager
% wrapper to call various programs for crossbounds of electrical
% conductivity and elastic bulk modulus

% Set default material properties
params = {'Cmin','Cfill','Kmin','Kfill','Gmin','Gfill','phi','phic'};
defans = {'.001',    '1', '  36','    2','  45','    0',' .3',' .4'};
answer = inputdlg(params , 'properties', 1, defans);
clrmap = jet;
if isempty(answer), return; end;
Cmin    = str2num(answer{1});
Cfill   = str2num(answer{2});
Kmin    = str2num(answer{3});
Kfill   = str2num(answer{4});
Gmin    = str2num(answer{5});
Gfill   = str2num(answer{6});
phi     = str2num(answer{7});
phic    = str2num(answer{8});

% Prompt for plotting mode
choice = radiodlg({'K-Cond crossbound functions'}, ...
                  {'2 G&T bounds on K-Cond, with Archie, all porosities', ...       % (1)
                   '3 G&T bounds & HS on K-Cond, all porosity lenses, color', ...   % (2)
                   '3 G&T bounds & HS on K-Cond, all porosity lenses, gray', ...    % (3)
                   '2 G&T bounds on K-Cond, all porosity lenses, truncated', ...    % (4)
                   'SCA and DEM models on K-Cond axes ', ...                        % (5)  
                   'Reduced range:  weighted averages of GT1&GT3, GT2&GT3',...      % (6)
                   '', ...% (7)
                   });
if isempty(choice), return; end;

% Make plots
if ismember(1,choice)   % 2 G&T bounds on K-Cond, with Archie, all porosities
    KS_GT_mtrends(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap)
end;
if ismember(2,choice)   % '3 G&T bounds&HS on K-Cond, all porosity lenses, color', ...
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 1, 1)    
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 1, 0)    
end;
if ismember(3,choice)   % 3 G&T bounds&HS on K-Cond, all porosity lenses, gray
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, gray, 2, 1)   
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, gray, 2, 0)   
end;
if ismember(4,choice)   % 2 G&T bounds on K-Cond, all porosity lenses, truncated
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 3, 1)   
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 3, 0)   
end;
if ismember(5,choice)   % SCA and DEM models on K-Cond axes 
    KS_inclusion_plotsB(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill+.00001, 0)
end;
if ismember(6,choice)   % Reduced range:  weighted averages of GT1&GT3, GT2&GT3
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 5, 1)   
    runGandT(Cmin, Cfill, Kmin, Kfill, Gmin, Gfill, phic, clrmap, 5, 0)   

end;

